% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/createDensity.R
\name{createDensity}
\alias{createDensity}
\title{Generates a density using random walks on a lattice.}
\usage{
createDensity(formLatticeOutput, PointPattern = NULL, M = 0.5, k,
  intensity = FALSE, sparse = TRUE)
}
\arguments{
\item{formLatticeOutput}{An object from formLattice or editLattice.}

\item{PointPattern}{A 2-column matrix or data frame of locations.}

\item{M}{Maximum probability of random walk moving.}

\item{k}{The smoothing parameter (number of steps).}

\item{intensity}{Plot an intensity vs a density.}

\item{sparse}{If TRUE, matrix computations are sparse.}
}
\value{
An object of type densityOut
\itemize{
  \item EW_locs A vector of EW coordinates of nodes.
  \item NS_locs A vector of NS coordinates of nodes.
  \item boundaryPoly The boundary of the region (two-columns).
  \item hole_list A list of polygonal holes in the region.
  \item PointPattern A 2-column matrix of observations.
  \item probs The probability distribution over the nodes.
  \item densityLBDE Density in a form for making a contour map.
  \item area The area of the region, with holes removed.}
}
\description{
Given a lattice and a point pattern of observations, 
createDensity starts random walks at each observation. 
k steps are taken and the output is a densityOut object, 
which can be used to plot a density estimate. If you wish 
to perform non-parametric regression, you should use the 
functions addQuantVar and createNparReg instead.
}
\details{
We start with an initial probability density p0 where the 
ith entry in p0 is the fraction of the point pattern that 
is nearest to the ith node. This is the empirical density 
function with no smoothing. If T is the transition matrix, 
and given a number of steps in the diffusion, T k p0 is the 
probability density of the diffusion after k steps. This is 
the major output of this function, along with information 
needed to produce a plot, including the polygons for the 
boundary and holes, and a vector of NS coordinates and EW 
coordinates used by the contour function. All of the necessary 
information for plotting is bundled in the object of class 
densityOutLBDE. Details of this process can be found in Barry 
and McIntyre (2011).
}
\examples{
plot.new()
data(polygon1)
nodeFillingOutput <- nodeFilling(poly=polygon1, node_spacing=0.02)
plot(nodeFillingOutput)
formLatticeOutput <- formLattice(nodeFillingOutput)
plot(formLatticeOutput)
Pointdata <- splancs::csr(polygon1,75)
Pointdata <- Pointdata[Pointdata[,1]<0.5,]
plot(polygon1,type="n")
polygon(polygon1)
points(Pointdata,pch=19)
out <- crossvalDensity(formLatticeOutput,PointPattern=Pointdata,
                      M=0.5,max_steps = 35)
densityOut <- createDensity(formLatticeOutput,
                           PointPattern=Pointdata, 
                           k=out$k,intensity=FALSE, sparse = TRUE)
plot(densityOut)
homerange(densityOut, percent = 0.95)


}
\references{
Ronald P. Barry, Julie McIntyre. Estimating animal 
densities and home range in regions with irregular 
boundaries and holes: A lattice-based alternative to 
the kernel density estimator. Ecological Modelling 
222 (2011) 1666-1672.
}
\author{
Ronald P. Barry
}
