% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/projectionTreeSearch.R
\name{randomProjectionTreeSearch}
\alias{randomProjectionTreeSearch}
\alias{randomProjectionTreeSearch.matrix}
\alias{randomProjectionTreeSearch.CsparseMatrix}
\alias{randomProjectionTreeSearch.TsparseMatrix}
\title{Find approximate k-Nearest Neighbors using random projection tree search.}
\usage{
randomProjectionTreeSearch(x, K = 150, n_trees = 50,
  tree_threshold = max(10, nrow(x)), max_iter = 1,
  distance_method = "Euclidean", seed = NULL, threads = NULL,
  verbose = getOption("verbose", TRUE))

\method{randomProjectionTreeSearch}{matrix}(x, K = 150, n_trees = 50,
  tree_threshold = max(10, nrow(x)), max_iter = 1,
  distance_method = "Euclidean", seed = NULL, threads = NULL,
  verbose = getOption("verbose", TRUE))

\method{randomProjectionTreeSearch}{CsparseMatrix}(x, K = 150, n_trees = 50,
  tree_threshold = max(10, nrow(x)), max_iter = 1,
  distance_method = "Euclidean", seed = NULL, threads = NULL,
  verbose = getOption("verbose", TRUE))

\method{randomProjectionTreeSearch}{TsparseMatrix}(x, K = 150, n_trees = 50,
  tree_threshold = max(10, nrow(x)), max_iter = 1,
  distance_method = "Euclidean", seed = NULL, threads = NULL,
  verbose = getOption("verbose", TRUE))
}
\arguments{
\item{x}{A (potentially sparse) matrix, where examples are columnns and features are rows.}

\item{K}{How many nearest neighbors to seek for each node.}

\item{n_trees}{The number of trees to build.}

\item{tree_threshold}{The threshold for creating a new branch.  The paper authors suggest
using a value equivalent to the number of features in the input set.}

\item{max_iter}{Number of iterations in the neighborhood exploration phase.}

\item{distance_method}{One of "Euclidean" or "Cosine."}

\item{seed}{Random seed passed to the C++ functions. If \code{seed} is not \code{NULL} (the default),
the maximum number of threads will be set to 1 in phases that would be non-determinstic otherwise.}

\item{threads}{The maximum number of threads to spawn. Determined automatically if \code{NULL} (the default).}

\item{verbose}{Whether to print verbose logging using the \code{progress} package.}
}
\value{
A [K, N] matrix of the approximate K nearest neighbors for each vertex.
}
\description{
A fast and accurate algorithm for finding approximate k-nearest neighbors.
}
\details{
Note that the algorithm does not guarantee that it will find K neighbors for each node. A
warning will be issued if it finds fewer neighbors than requested. If the input data contains
distinct partitionable clusters, try increasing the \code{tree_threshold} to increase the number
of returned neighbors.
}
