% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/visualize.R
\name{manifoldMapStretch}
\alias{manifoldMapStretch}
\title{manifoldMapStretch}
\usage{
manifoldMapStretch(x, f, size_x = 500, size_y = 500, image_size = 50, ...)
}
\arguments{
\item{x}{A [N,D] matrix of coordinates.}

\item{f}{A function that, called with the index number of a row of \code{x}, returns an R object representing
an image. See the example.}

\item{size_x}{The width of the requested plot, in pixels.}

\item{size_y}{The height of the requested plot, in pixels.}

\item{image_size}{The size to plot each image; each is plotted as a square.}

\item{...}{Additional parameters passed to \code{plot}.}
}
\description{
A manifold map that fills the full extent of the plot.
}
\details{
Ported from \url{http://cs.stanford.edu/people/karpathy/cnnembed/}.  Each position is filled with its nearest neighbor.
}
\note{
This function is experimental.
}
\examples{
\dontrun{
# Demonstration of f
load(system.file("extdata", "faces.Rda", package="largeVis"))

imagepaths <- paste("pathtoimages",
   faceLabels[,1], sub("png", "jpg", faceLabels[,2]), sep = "/")

manifoldMapStretch(as.matrix(faceCoords[,1:2]),
   f = function(x) jpeg::readJPEG(imagePaths[x]),
   size_x = 5000, size_y = 5000, image_size = 100)
}

}

