% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dalex_explainers.R
\name{h2o_explainer}
\alias{h2o_explainer}
\alias{dalex_explainer}
\title{DALEX Explainer for H2O}
\usage{
h2o_explainer(df, model, y = "tag", ignore = NULL, ...)
}
\arguments{
\item{df}{Dataframe. Must contain all columns and predictions}

\item{model}{Model object (H2O)}

\item{y}{Character or Variable name. Variable's column name.}

\item{ignore}{Character vector. Which columns should be ignored?}

\item{...}{Additional parameters to pass to \code{h2o_predict_model} or
\code{h2o_predict_MOJO}.}
}
\value{
List; explainer. Containing the model, data, y, predict_function,
y_hat, residuals, class, label, model_info, residual_function, and weights.
}
\description{
DALEX helper function to create an \code{explainer} object using
a \code{h2o} trained model.
}
\examples{
# You must have "DALEX" library to use this auxiliary function:
\dontrun{
data(dft) # Titanic dataset

# TRAIN A SIMPLE MODEL
dfm <- h2o_automl(dft,
  y = "Survived",
  ignore = c("Ticket", "PassengerId", "Cabin"),
  max_models = 1
)

# EXPLAINER
explainer <- h2o_explainer(df = dfm$datasets$test, model = dfm$model, y = "Survived")
explainer$data <- na.omit(explainer$data)

# CATEGORICAL EXAMPLE
class <- dalex_variable(explainer, vars = c("Pclass", "Sex"))
class$plot

# NUMERICAL EXAMPLE
num <- dalex_variable(explainer, vars = c("Fare", "Age"))
num$plot

# LOCAL EXAMPLE
local <- dalex_local(explainer, row = 1)
# OR YOU COULD MANUALLY INPUT THE OBSERVATION
local <- dalex_local(explainer, observation = explainer$data[1, ])
local$plot

# xai2shiny's UI (needs to be installed from ModelOriented/xai2shiny)
xai2shiny(explainer, run = TRUE)
}
}
\seealso{
Other Interpretability: 
\code{\link{dalex_local}()},
\code{\link{dalex_residuals}()},
\code{\link{dalex_variable}()}
}
\concept{Interpretability}
