% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/stocks.R
\name{daily_stocks}
\alias{daily_stocks}
\title{Daily Stocks Dataframe}
\usage{
daily_stocks(hist, trans, tickers = NA, window = "MAX")
}
\arguments{
\item{hist}{Dataframe. Result from \code{stocks_hist()}}

\item{trans}{Dataframe. Result from \code{stocks_file()$transactions}}

\item{tickers}{Dataframe. Result from \code{stocks_file()$portfolio}}

\item{window}{Character. Choose any of: "1W", "1M", "6M", "1Y", "YTD", "5Y", "MAX"}
}
\value{
data.frame. Processed at date and symbol level.
}
\description{
This function creates a dataframe with all relevant metrics and values,
for each ticker or symbol, for every day since inception.
}
\seealso{
Other Investment: 
\code{\link{daily_portfolio}()},
\code{\link{etf_sector}()},
\code{\link{splot_change}()},
\code{\link{splot_divs}()},
\code{\link{splot_etf}()},
\code{\link{splot_growth}()},
\code{\link{splot_roi}()},
\code{\link{splot_summary}()},
\code{\link{splot_types}()},
\code{\link{stocks_file}()},
\code{\link{stocks_hist}()},
\code{\link{stocks_obj}()},
\code{\link{stocks_quote}()},
\code{\link{stocks_report}()}
}
\concept{Investment}
