% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/facebook.R
\name{fb_posts}
\alias{fb_posts}
\title{Facebook Page Posts API}
\usage{
fb_posts(
  token,
  n = 150,
  limits = 100,
  comments = FALSE,
  shares = FALSE,
  reactions = FALSE
)
}
\arguments{
\item{token}{Character. Valid access token with sufficient privileges. Visit the
\href{https://developers.facebook.com/tools/explorer}{Facebook API Graph Explorer}
to acquire one.}

\item{n}{Integer. How many most recent posts do you need?}

\item{limits}{Integer. For each post, hoy many results do you need?}

\item{comments, shares, reactions}{Boolean. Include in your query?}
}
\value{
data.frame with un-nested processed results fetched with API.
}
\description{
Connect to an API Graph's token of a given page and get posts,
comments, shares, and reactions of n posts (with no limits).
}
\examples{
\dontrun{
token <- YOURTOKEN
# Query latest 10 posts and 50 comments for each
posts <- fb_posts(token, n = 10, limits = 50, comments = TRUE)
}
}
\seealso{
Other API: 
\code{\link{bring_api}()},
\code{\link{fb_accounts}()},
\code{\link{fb_ads}()},
\code{\link{fb_creatives}()},
\code{\link{fb_insights}()},
\code{\link{fb_post}()},
\code{\link{fb_process}()},
\code{\link{fb_rf}()},
\code{\link{fb_token}()},
\code{\link{li_auth}()},
\code{\link{li_profile}()},
\code{\link{queryGA}()},
\code{\link{slackSend}()}

Other Facebook: 
\code{\link{fb_accounts}()},
\code{\link{fb_ads}()},
\code{\link{fb_creatives}()},
\code{\link{fb_insights}()},
\code{\link{fb_post}()},
\code{\link{fb_process}()},
\code{\link{fb_rf}()},
\code{\link{fb_token}()}
}
\concept{API}
\concept{Facebook}
