% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/text_mining.R
\name{ngrams}
\alias{ngrams}
\title{Build N-grams and keep most frequent}
\usage{
ngrams(text, ngram = c(2, 3), top = 10, stop_words = NULL, ...)
}
\arguments{
\item{text}{Character vector}

\item{ngram}{Integer vector. Number of continuous n items in text.}

\item{top}{Integer. Keep n most frequent ngrams only.}

\item{stop_words}{Character vector. Words to exclude from text. Example: 
if you want to exclude "a", whenever that word appears it will be excluded,
but when the letter "a" appears in a word, it will remain.}

\item{...}{Additional parameters passed to \code{remove_stopwords}.}
}
\value{
data.frame with ngrams and counters, sorted by frequency.
}
\description{
Build out n-grams for multiple text inputs and keep the n most frequent
combinations.
}
\examples{
# You must have "tidytext" library to use this auxiliary function: 
\dontrun{
women <- read.csv("https://bit.ly/3mXJOOi")
x <- women$description
ngrams(x, ngram = c(2,3), top  = 3)
ngrams(x, ngram = 2, top = 6, stop_words = c("a","is","of","the"))
}
}
\seealso{
Other Text Mining: 
\code{\link{cleanNames}()},
\code{\link{cleanText}()},
\code{\link{remove_stopwords}()},
\code{\link{replaceall}()},
\code{\link{sentimentBreakdown}()},
\code{\link{textCloud}()},
\code{\link{textFeats}()},
\code{\link{textTokenizer}()},
\code{\link{topics_rake}()}
}
\concept{Text Mining}
