% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/google_trends.R
\name{trendsRelated}
\alias{trendsRelated}
\title{Google Trends: Related Plot}
\usage{
trendsRelated(gtrend, top = NA, title = NA, note = NA, exclude = NULL)
}
\arguments{
\item{gtrend}{List. Result from \code{gtrendsR::gtrends(keyword, geo, time)}}

\item{top}{Integer. Filter top n results only.}

\item{title}{Character. Custom title for the plot.}

\item{note}{Character. Add a note to the plot if needed.}

\item{exclude}{Character vector. Which observations do you wish to exclude?}
}
\value{
plot for Google Trend's results input \code{gtrend}.
}
\description{
This function creates a plot with Google Trend's related topics 
and queries, and let the user compare different keywords.
}
\seealso{
Other Exploratory: 
\code{\link{corr_cross}()},
\code{\link{corr_var}()},
\code{\link{crosstab}()},
\code{\link{df_str}()},
\code{\link{distr}()},
\code{\link{freqs_df}()},
\code{\link{freqs_list}()},
\code{\link{freqs_plot}()},
\code{\link{freqs}()},
\code{\link{lasso_vars}()},
\code{\link{missingness}()},
\code{\link{plot_cats}()},
\code{\link{plot_df}()},
\code{\link{plot_nums}()},
\code{\link{tree_var}()}

Other Scrapper: 
\code{\link{filesGD}()},
\code{\link{get_mp3}()},
\code{\link{holidays}()},
\code{\link{ip_data}()},
\code{\link{readGS}()},
\code{\link{splot_etf}()},
\code{\link{stocks_hist}()},
\code{\link{stocks_quote}()},
\code{\link{writeGS}()}

Other Google Trends: 
\code{\link{trendsTime}()}

Other Google: 
\code{\link{filesGD}()},
\code{\link{queryGA}()},
\code{\link{readGS}()},
\code{\link{trendsTime}()},
\code{\link{writeGS}()}
}
\concept{Exploratory}
\concept{Google}
\concept{Google Trends}
\concept{Scrapper}
