% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lambda-config.R
\name{function_accepts_context}
\alias{function_accepts_context}
\title{Determine if a function accepts a \code{context} argument}
\usage{
function_accepts_context(func)
}
\arguments{
\item{func}{Function that may or may not accept a \code{context} argument}
}
\value{
logical
}
\description{
The context of a Lambda is the metadata associated with each request, such as
the ARN. In other languages, a function used in a Lambda must accept the
context as an argument. We allow here for functions that disregard it, since
it's not necessary.

The purpose of \code{functions_accepts_context} then is to determine if the
arguments of the function defined by the handler includes \code{context}, in which
case we pass the \code{context} as an argument whenever the Lambda is invoked. The
\code{context} argument must be named (\code{...} won't be recognised). Primitive
functions will always return FALSE.
}
\keyword{internal}
