% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/endpoints.R
\name{endpoints}
\alias{endpoints}
\alias{get_next_invocation_endpoint}
\alias{get_initialisation_error_endpoint}
\alias{get_response_endpoint}
\alias{get_invocation_error_endpoint}
\title{AWS Lambda endpoints}
\usage{
get_next_invocation_endpoint(config, runtime_api)

get_initialisation_error_endpoint(config, runtime_api)

get_response_endpoint(config, request_id)

get_invocation_error_endpoint(config, request_id)
}
\arguments{
\item{config}{A list of configuration values as created by the
\code{\link{lambda_config}} function. Alternatively, a runtime API host can
be provided directly. This would be the case if there's not enough
information available to build a full configuration object due to an error.}

\item{request_id}{For \code{get_response_endpoint} and
\code{get_invocation_error_endpoint}, the ID of the particular event/request.
This is provided in the "lambda-runtime-aws-request-id" header of the
event.}
}
\value{
character
}
\description{
These endpoints are configured based on the "AWS_LAMBDA_RUNTIME_API"
environment variable set by AWS Lambda during initialisation. They generally
won't be available locally. The "AWS_LAMBDA_RUNTIME_API" environment variable
(accessed through \code{\link{lambda_config}}) is used in the following
functions:
\itemize{
\item \code{get_next_invocation_endpoint} returns the endpoint which R must query for
the next input. R must send a \code{GET} request to this endpoint and will wait
until either a response is received or the Lambda instance is shut down for
inactivity. When Lambda receives an input from, say, an API Gateway, it will
respond to the pending request with details of the input.
\item \code{get_initialisation_error_endpoint} returns the endpoint to which an error
should be sent if the error occurs when setting up the runtime. This is
distinct from errors that occur during handling of an event.
\item \code{get_response_endpoint} returns the endpoint to which an event response
should be sent. It is unique for each event.
\item \code{get_invocation_error_endpoint} returns the endpoint to which errors that
occur during event handling should be sent. It is unique for each event.
}

The values returned by \code{get_next_invocation_endpoint} and
\code{get_initialisation_error_endpoint} are unique in each Lambda instance. That
is, the runtime only needs to retrieve their values once. The values returned
by \code{get_response_endpoint} and \code{get_invocation_error_endpoint} are determined
by the \code{request_id} argument that these functions require, and so need to be
recalculated for each event. The request ID is given in the
"lambda-runtime-aws-request-id" header in the event.
}
\keyword{internal}
