% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/recode_vals.R
\name{recode_vals}
\alias{recode_vals}
\title{Recode Values of a Free-standing Vector}
\usage{
recode_vals(x, bef, aft, default.lab = "bef", unique = FALSE)
}
\arguments{
\item{x}{an integer, character, factor, or logical vector.}

\item{bef}{the "before" (i.e., current) values of x to be recoded.}

\item{aft}{the "after" (recoded) values to be substituted in the returned
vector in place of the positionally corresponding bef values of the x vector
("positionally corresponding" means that the first element of aft is the
replacement (recode) for all x instances of the first element of bef, and so
on for the respective second bef and aft elements, etc.; see examples).
variables to which value labels will be added.}

\item{default.lab}{the "aft" value to be used for values of x for which no
"bef" value is specified. default.lab = "bef" (the default) will use
(retain) the existing value of x as its own recode, coercing to character
as needed. For example, if the value x=4 is observed in x but is not included
in the "bef" argument, the returned vector will have values of 4 (integer)
or "4" (character), depending on whether the recodes that --are-- supplied
are numeric (then 4) or character (then "4").}

\item{unique}{if TRUE, return only the mapping itself (bef argument values as
names, aft argument values as values), else if FALSE (default), return the
full recoded vector of x values.}
}
\value{
A vector of length equal length of supplied vector, with x values
found in bef argument switched to the corresponding values found in the aft
argument.
}
\description{
Takes a stand-alone vector (x), and recodes select values (bef) to
some other set of values (aft), returning the recoded vector.
}
\details{
While labelr users do not need to engage \code{recode_vals} directly, it is the
underlying function that powers certain core labelr functions, including
\code{add_val_labs} and \code{add_name_labs}. The bef argument identifies the values of
x to recode, and aft argument indicates what each bef value should be recoded
to (order matters: bef=c("a", "b", "c"), aft=c(1, 2, 3) means that "a" values
of x will be recoded to 1 values in returned vector, "b" values will be
recoded to 2, and "c" values will be recoded to 3).
}
\examples{
z <- mtcars$gear
z[1] <- NA
z
recode_vals(z, c(5, 3, 4), c("five", "three", "four"))
irsp <- iris$Species[c(1:3, 60:62, 148:150)]
irsp
recode_vals(irsp, c("setosa", "versicolor", "virginica"), c("SE", "VE", "VI"))
class(irsp) # factor
class(recode_vals(
  irsp, c("setosa", "versicolor", "virginica"),
  c("SE", "VE", "VI")
)) # coerced to character
set.seed(112)
x_logic <- sample(c(TRUE, FALSE), 10, replace = TRUE)
x_logic
recode_vals(x_logic, bef = c(FALSE), c("Fake News!"))
}
