% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/use_val_labs.R
\name{use_val_labs}
\alias{use_val_labs}
\alias{uvl}
\title{Swap Variable Value Labels for Variable Values}
\usage{
use_val_labs(data, vars = NULL)

uvl(data, vars = NULL)
}
\arguments{
\item{data}{a data.frame.}

\item{vars}{the names of the columns (variables) for which value labels will
will replace original values in the returned data.frame.}
}
\value{
A data.frame, with (all or the select) variable value labels
substituted for original variable values and any affected variables coerced
to character if they were not already.
}
\description{
Replace the actual values of data.frame variables with the corresponding
value labels (previous assigned using \code{add_val_labs} or a related function).
}
\details{
Note: \code{uvl} is a compact alias for \code{use_val_labs}: they do the same thing,
and the former is easier to type.

\code{use_val_labs} takes a variable value-labeled data.frame and substitutes each
(labeled) variable's value labels for its values, returning a data.frame whose
dimensions, names, and members are the same as the inputted data.frame. This
may be useful if one wishes to view data.frame information using the
(potentially) more intuitively meaningful value labels (e.g., gender=1 values
displayed as "Male" instead of 1).

#' Warning: \code{use_val_labs} will replace existing variable values with value
labels and cannot be undone. If you wish to preserve variable values, be sure
to assign the result of \code{use_val_labs} to a new object. For other ways to
leverage value labels for common data management or inspection tasks, while
preserving raw data values in returned object, see \code{add_lab_cols},
\code{add_lab_dummies}, \code{flab}, \code{slab}, \code{tabl}, \code{headl}, \code{taill}, and \code{somel}.
}
\examples{
# Example #1 - mtcars example, one variable at a time
# one variable at a time, mtcars
df <- mtcars
# now, add value labels
df <- add_val_labs(
  data = df,
  vars = "am",
  vals = c(0, 1),
  labs = c("automatic", "manual")
)

df <- add_val_labs(
  data = df,
  vars = "carb",
  vals = c(1, 2, 3, 4, 6, 8),
  labs = c(
    "1-carb", "2-carbs",
    "3-carbs", "4-carbs",
    "6-carbs", "8-carbs"
  )
)

# var arg can be unquoted if using add_val1()
# note that this is not add_val_labs(); add_val1() has "var" (not "vars) arg
df <- add_val1(
  data = df,
  var = cyl, # note, "var," not "vars" arg
  vals = c(4, 6, 8),
  labs = c(
    "four-cyl",
    "six-cyl",
    "eight-cyl"
  )
)

df <- add_val_labs(
  data = df,
  vars = "gear",
  vals = c(3, 4),
  labs = c(
    "3-speed",
    "4-speed"
  )
)

# Oops, we forgot 5-speeds; let's finish the job.
df <- add_val_labs(
  data = df,
  vars = "gear",
  vals = 5,
  labs = "5-speed"
)

head(use_val_labs(df), 3) # they're there

# Example #2 - (Fake) Likert Data
# add val labs to multiple variables at once
# make a "Likert"-type fake data set to demo
# note, by default, add_val_labs() "vars" arg will do partial matching
# in this case, we catch all vars with "x" in their name
set.seed(272)
dflik <- make_likert_data(scale = 1:7)
vals2label <- 1:7
labs2use <- c(
  "VSD",
  "SD",
  "D",
  "N",
  "A",
  "SA",
  "VSA"
)

dflik <- add_val_labs(
  data = dflik, vars = c("x", "y3"), # note the vars args
  vals = vals2label,
  labs = labs2use,
  partial = TRUE
)

# note, all "x" vars get the labs, as does "y3"
# see vars = args above
lik1 <- use_val_labs(dflik)
head(lik1)
# keep a copy
dflik_conv <- use_val_labs(dflik)
head(dflik_conv, 3)
}
