% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_val_lab1.R
\name{get_val_lab1}
\alias{get_val_lab1}
\alias{gvl1}
\title{Return Look-up Table of One Variable's Value Labels}
\usage{
get_val_lab1(data, var, simplify = FALSE)

gvl1(data, var, simplify = FALSE)
}
\arguments{
\item{data}{a data.frame.}

\item{var}{the unquoted name of the variable (column) for which a value-to-label
look-up mapping is sought.}

\item{simplify}{return the mapping as a named vector, not a data.frame
(defaults to FALSE).}
}
\value{
By default, a three-column data.frame, consisting of "var", "vals",
and "labs" columns, where each row corresponds to a unique value of var OR --
for variables labeled using \code{add_quant_labs} (or \code{add_quant1}) -- the
approximate (i.e., possibly rounded) upper bound of numerical values that
fall within that label's range of coverage.  If simplify is FALSE, a character
vector will returned.
}
\description{
For a data.frame with value-labeled variables, \code{get_val_lab1} returns a
derivative data.frame or vector that shows the value-to-label mapping for
each unique value of that value-labeled variable.
}
\details{
\code{get_val1} is a variant of \code{get_val_labs} that allows you to specify
only one var whose value-to-label mapping you wish to look up.

Note 1: As with \code{get_val_labs()}, \code{get_val_lab1()} exists to provide a visual,
human-interpretable quick look at how value labels map to underlying values
and is NOT intended for use in automated querying, subsetting, or other
manipulation of those value labels. Further: Unlike \code{get_val_labs()}, which
may return value-to-label mappings for --several-- variables of potentially
different atomic types, \code{get_val_lab1()} limits itself to returning the value
labels of a --single-- variable (column) of the supplied data.frame.

For this reason, and in contrast to the behavior of \code{get_val_labs()}, if
\code{get_val_lab1()}'s simplify argument is set to FALSE (the default), the
returned data.frame will express var values as numeric if this can be done
without creating new NA values (i.e., in the sense of \code{as_numv()}). In
contrast, if simplify is TRUE, the look-up table information will be returned
as a named character vector.

Note 2: \code{gvl1} is a compact alias for \code{get_val_lab1}: they do the same thing,
and the former is easier to type
}
\examples{
# add val labs to multiple variables at once
# make a "Likert"-type fake data set to demo
# note, by default, add_val_labs() "vars" arg will do partial matching
# in this case, we catch all vars with "x" in their name
set.seed(272)
dflik <- make_likert_data(scale = 1:7)
vals2label <- 1:7
labs2use <- c(
  "VSD",
  "SD",
  "D",
  "N",
  "A",
  "SA",
  "VSA"
)

dflik <- add_val_labs(
  data = dflik, vars = c("x", "y3"), # note the vars args
  vals = vals2label,
  labs = labs2use,
  partial = TRUE
)

# note, all "x" vars get the labs, as does "y3"
get_val_lab1(dflik, x1)

get_val_lab1(dflik, x1, simplify = TRUE)
}
