% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/as_numv.R
\name{as_numv}
\alias{as_numv}
\title{Convert a "Suitable" Character Vector to Numeric}
\usage{
as_numv(x, nan2na = TRUE, inf2na = TRUE)
}
\arguments{
\item{x}{a character vector.}

\item{nan2na}{a logical argument. TRUE if the non-case-sensitive string "nan"
should be converted to NA.}

\item{inf2na}{a logical argument. TRUE if the non-case-sensitive strings
"inf" or "-inf should be converted to NA.}
}
\value{
a vector, converted to numeric if feasible (else, the same character
vector that was supplied).
}
\description{
\code{as_numv} determines whether a character vector can be coerced to numeric
without generating new NA values and, if so, it makes that conversion
(similar to Stata's destring command).
}
\details{
Core labelr functions coerce integers to characters and back, which
\code{as_numv} facilitates. Note that character values of "NA" (including "na",
"Na", and "nA") will be converted to NA and, by default, so will other
"irregular" values (in the sense of \code{check_irregular}).
}
\examples{
set.seed(123)
x1 <- runif(10)
x2 <- as.character(sample(c(1:20), 10, replace = TRUE))
x2_num <- as_numv(x2)
class(x2)
class(x2_num)
head(x2)
}
