% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/add_val_labs.R
\name{add_val_labs}
\alias{add_val_labs}
\alias{avl}
\title{Add or Modify a Variable's Value Labels}
\usage{
add_val_labs(
  data,
  vars,
  vals,
  labs,
  partial = FALSE,
  not.vars = NULL,
  max.unique.vals = 10,
  init = FALSE
)

avl(
  data,
  vars,
  vals,
  labs,
  partial = FALSE,
  not.vars = NULL,
  max.unique.vals = 10,
  init = FALSE
)
}
\arguments{
\item{data}{a data.frame.}

\item{vars}{a character vector that corresponds to the name(s) of one or more
variables to which value labels will be added.}

\item{vals}{a vector of distinct values of the actual variable, each of which
is to be associated with a label supplied to the labs argument in the same
positional order (e.g., vals = c(1,0), labs = c("manual", "automatic") will
associate lab "manual" with val 1 and lab "automatic" with val 0.). Note:
NA and other "irregular" (e.g., NaN, Inf) values all are automatically
assigned the label "NA", and this cannot be overridden. Note that you do not
need to specify all unique vals of var, and you can supply value labels
incrementally, one (or a few, or all) unique vals of var at a time. Once
you've added the value label, it is bound to that value until you drop it
(see \code{drop_val_labs}) or some other action (intentional or otherwise) strips
or overwrites it.}

\item{labs}{a character vector of distinct label values, each of which
is to be associated with exactly one corresponding distinct value (vals
argument element) of the variable(s) identified in the vars argument. The
order of labs argument must match that of vals argument entries (e.g., if a
three-element vector of values is supplied to vals, then a three-element
vector of proposed labels must be supplied to labs, and the first value of
vals will get the first label of labs, the second value of vals will get the
second label of labs, etc.). Note: NA and other "irregular" (e.g., NaN, Inf)
values are automatically assigned the label "NA" and may not be assigned
another label.}

\item{partial}{To apply the same value labeling scheme to many variables
at once, you can provide those variable names explicitly (e.g., vars =
c("x1","x2", "x3") or vars = paste0("x", 1:3), or you can provide a substring
only and set partial = TRUE (default is FALSE). For example, to apply the
same labeling scheme to vars "x1", "x2" ... sequentially through "x10",
you could use vars = c("x"), along with partial = TRUE. Be careful with
this, as it also will attempt to apply the scheme to "sex" or "tax.bracket",
etc.}

\item{not.vars}{use of the partial argument can result in situations where
you inadvertently attempt to value-label a variable. For example, if vars="x"
and partial=TRUE, then \code{add_val_labs} will attempt to label not only "x1",
"x2","x3", and "x4", but also "sex", "tax.bracket.", and other "x"-containing
variable names. Use of not.vars allows you to indicate variables that match
your vars argument that you do not wish to attempt to value-label. Note that
not.vars gets priority: setting vars="x", partial=TRUE, and not.vars="x" is
tantamount to telling add_val_labs() that you actually do not wish to label
any of the variables that you specified in vars, resulting in no variables
receiving value labels.}

\item{max.unique.vals}{\code{add_val_labs}() will not assign value labels to non-
integer (i.e., decimal-having) numeric variables. The max.unique.vals
argument further constrains the variables that may receive value labels to
those whose total unique values do not exceed the integer value supplied to
this argument. Note that labelr sets a hard ceiling of 5000 on the total
number of unique value labels that any variable is permitted to have under
any circumstance, as labelr is primarily intended for interactive use with
moderately-sized (<=~1M-row) data.frames.}

\item{init}{assign placeholder labels for variables that lack decimals
and meet the max.unique.vals threshold.}
}
\value{
A data.frame, with new variable value labels added (call
\code{get_val_labs} to see them), other provisional/default labelr label
information added, and previous user-added labelr label information
preserved.
}
\description{
Add variable value-specific, descriptive value labels to a data.frame.
}
\details{
Note: \code{avl} is a compact alias for \code{add_val_labs}: they do the same thing,
and the former is easier to type

\code{add_val_labs} is intended for associating value labels with binary,
nominal, or ordinal (e.g., integer) variables, where each of a limited number
of distinct values is to be associated one-to-one with a distinct value label.
To assign labels to ranges of numerical variables, see \code{add_quant_labs} (or
\code{add_quant1}). To apply the same label to multiple distinct values of a
variable, see \code{add_m1_lab} or \code{add1m1}.

\code{add_val_labs} works with other labelr functions (e.g., \code{add_val1},
\code{drop_val_labs}, \code{get_val_labs}, \code{use_val_labs}, \code{add_lab_cols}) to
facilitate the creation, accessing, modification, use, or deletion of
variable value labels.

When using \code{add_val_labs} or \code{add_val1}, each distinct variable value can
receive one and only one value label, and for any given variable, each unique
label can be assigned to only one unique value (e.g., mtcars$gear==3 and
mtcars$gear==4 cannot both share a single "3 or 4 gears" label: each of these
two distinct values must have its own label). This latter constraint may be
relaxed by using \code{add_m1_lab}.

If partial = TRUE, \code{add_val_labs} will apply the specified labeling scheme to
all variables that contain a key variable name substring of interest
(supplied to the vars argument), which may be one or more variables found in
the data.frame (see Example #2).
}
\examples{
# Example #1 - mtcars example, one variable at a time
# one variable at a time, mtcars
df <- mtcars
# now, add value labels
df <- add_val_labs(
  data = df,
  vars = "am",
  vals = c(0, 1),
  labs = c("automatic", "manual")
)

df <- add_val_labs(
  data = df,
  vars = "carb",
  vals = c(1, 2, 3, 4, 6, 8),
  labs = c(
    "1-carb", "2-carbs",
    "3-carbs", "4-carbs",
    "6-carbs", "8-carbs"
  )
)

# var arg can be unquoted if using add_val1()
# note that this is not add_val_labs(); add_val1() has "var" (not "vars" arg)
df <- add_val1(
  data = df,
  var = cyl, # note, "var," not "vars" arg
  vals = c(4, 6, 8),
  labs = c(
    "four-cyl",
    "six-cyl",
    "eight-cyl"
  )
)

df <- add_val_labs(
  data = df,
  vars = "gear",
  vals = c(3, 4),
  labs = c(
    "3-speed",
    "4-speed"
  )
)

# Oops, we forgot 5-speeds; let's finish the job.
df <- add_val_labs(
  data = df,
  vars = "gear",
  vals = 5,
  labs = "5-speed"
)

head(use_val_labs(df), 3) # they're there

# Example #2 - (Fake) Likert Data
# add val labs to multiple variables at once
# make a "Likert"-type fake data set to demo
# note, by default, add_val_labs() "vars" arg will do partial matching
# in this case, we catch all vars with "x" in their name
set.seed(272)
dflik <- make_likert_data(scale = 1:7)
vals2label <- 1:7
labs2use <- c(
  "VSD",
  "SD",
  "D",
  "N",
  "A",
  "SA",
  "VSA"
)

dflik <- add_val_labs(
  data = dflik, vars = c("x", "y3"), # note the vars args
  vals = vals2label,
  labs = labs2use,
  partial = TRUE
)

# note, all "x" vars get the labs, as does "y3"
# see vars = args above
lik1 <- use_val_labs(dflik)
head(lik1)
# keep a copy
dflik_conv <- use_val_labs(dflik)
head(dflik_conv, 3)
}
