% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/schange.R
\name{schange}
\alias{schange}
\title{Safely Change or Add a Data Frame Variable (Column)}
\usage{
schange(data, ...)
}
\arguments{
\item{data}{a data.frame.}

\item{...}{an expression that will create or update a column in data.}
}
\value{
a data.frame.
}
\description{
\code{schange} allows one to modify or add a column to a data.frame while
preserving the labelr attributes attached to the inputted data.frame.
}
\details{
Note that, while \code{schange} preserves label meta-data of the supplied
data.frame, it does not update or add any new labels. Therefore, if you are
altering the range of values for an extant variable or adding a new variable
to the data.frame, you will need to explicitly instantiate any new or
modified labels that you desire via follow-up calls to functions such as
\code{add_val_labs()}, \code{drop_val_labs()}, etc.
}
\examples{
df <- mtcars
# now, add value labels
df <- add_val_labs(
  data = df,
  vars = "am",
  vals = c(0, 1),
  labs = c("automatic", "manual")
)

df <- add_val_labs(
  data = df,
  vars = "carb",
  vals = c(1, 2, 3, 4, 6, 8),
  labs = c(
    "1-carb", "2-carbs",
    "3-carbs", "4-carbs",
    "6-carbs", "8-carbs"
  )
)

df <- schange(df, mpg_sq = mpg^2) # create var "mpg_sq"
df <- schange(df, am = ifelse(am == 0, 2, am)) # modify/replace var "am"

head(df, 4) # show that data.frame modifications have been made
get_all_lab_atts(df) # labels are intact; "val.labs.am" needs updating!
df <- drop_val_labs(
  data = df,
  vars = "am"
)

df <- add_val_labs(
  data = df,
  vars = "am",
  vals = c(1, 2),
  labs = c("manual", "automatic")
)
get_val_labs(df)
}
