% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/labelled.R
\name{labelled}
\alias{is.labelled}
\alias{labelled}
\title{Create a labelled vector.}
\usage{
labelled(x, labels)

is.labelled(x)
}
\arguments{
\item{x}{A vector to label. Must be either numeric (integer or double) or
character.}

\item{labels}{A named vector. The vector should be the same type as
x. Unlike factors, labels don't need to be exhaustive: only a fraction
of the values might be labelled.}
}
\description{
A labelled vector is a common data structure in other statistical
environments. This class makes it possible to import such labelled vectors
in to without loss of fidelity.
}
\examples{
s1 <- labelled(c('M', 'M', 'F'), c(Male = 'M', Female = 'F'))
s2 <- labelled(c(1, 1, 2), c(Male = 1, Female = 2))
is.labelled(s1)
is.labelled(c('M', 'M', 'F'))
}

