% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/to_factor.R
\name{to_factor}
\alias{to_factor}
\alias{to_factor.default}
\alias{to_factor.labelled}
\title{Convert input to a factor.}
\usage{
to_factor(x, ...)

\method{to_factor}{default}(x, ...)

\method{to_factor}{labelled}(x, levels = c("labels", "values", "prefixed"),
  ordered = FALSE, missing_to_na = FALSE, nolabel_to_na = FALSE,
  sort_levels = c("auto", "none", "labels", "values"), decreasing = FALSE,
  ...)
}
\arguments{
\item{x}{Object to coerce to a factor.}

\item{...}{Other arguments passed down to method.}

\item{levels}{What should be used for the factor levels: the labels, the values or labels prefixed with values?}

\item{ordered}{\code{TRUE} for ordinal factors, \code{FALSE} (default) for nominal factors.}

\item{missing_to_na}{Should defined missing values be converted to `NA`?}

\item{nolabel_to_na}{Should values with no label be converted to `NA`?}

\item{sort_levels}{How the factor levels should be sorted? (see Details)}

\item{decreasing}{Sould levels be sorted in decreasing order?}
}
\description{
The base function \code{\link[base]{as.factor}} is not a generic, but this variant
is. By default, \code{to_factor} is a wrapper for \code{\link[base]{as.factor}}.
Please note that \code{to_factor} differs slightly from \code{\link[haven]{as_factor}}
method provided by \code{haven} package.
}
\details{
If some values doesn't have a label, automatic labels will be created, except if
  \code{nolabel_to_na} is \code{TRUE}.

  If \code{sort_levels == 'values'}, the levels will be sorted according to the values of \code{x}.
  If \code{sort_levels == 'labels'}, the levels will be sorted according to labels' names.
  If \code{sort_levels == 'none'}, the levels will be in the order the value labels are defined
  in \code{x}. If some labels are automatically created, they will be added at the end.
  If \code{sort_levels == 'auto'}, \code{sort_levels == 'none'} will be used, except if some
  values doesn't have a defined label. In such case,  \code{sort_levels == 'values'} will
  be applied.
}
\examples{
v <- labelled(c(1,2,2,2,3,9,1,3,2,NA), c(yes = 1, no = 3, "don't know" = 9), c(FALSE, FALSE, TRUE))
to_factor(v)
to_factor(v, missing_to_na = FALSE, nolabel_to_na = TRUE)
to_factor(v, 'p')
to_factor(v, sort_levels = 'v')
to_factor(v, sort_levels = 'n')
to_factor(v, sort_levels = 'l')

x <- labelled(c('H', 'M', 'H', 'L'), c(low = 'L', medium = 'M', high = 'H'))
to_factor(x, ordered = TRUE)
}

