% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ksNN.R
\name{ksNN}
\alias{ksNN}
\title{This function calculates the prediction value of k* nearest neighbors algorithm.}
\usage{
ksNN(Label, Distance, L_C = 1)
}
\arguments{
\item{Label}{vectors of the known labels of the samples.}

\item{Distance}{vectors of the distance between the target sample we want to predict and the other samples.}

\item{L_C}{parameter of k* nearest neighbors algorithm.}
}
\value{
the prediction value(pred) and the weight of the samples(alpha).
}
\description{
This function calculates the prediction value of k* nearest neighbors algorithm.
}
\note{
This algorithm is based on Anava and Levy(2017).
}
\examples{
  library(ksNN)
  set.seed(1)

  #make the nonlinear regression problem
  X<-runif(100)
  Y<-X^6-3*X^3+5*X^2+2

  suffle<-order(rnorm(length(X)))
  X<-X[suffle]
  Y<-Y[suffle]

  test_X<-X[1]
  test_Y<-Y[1]

  train_X<-X[-1]
  train_Y<-Y[-1]

  Label<-train_Y
  Distance<-sqrt((test_X-train_X)^2)

  pred_ksNN<-ksNN(Label,Distance,L_C=1)

  #the predicted value with k*NN
  pred_ksNN$pred

  #the 'true' value
  test_Y
}
