% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/kpmt.R
\name{kpmt}
\alias{kpmt}
\title{Known Population Median Test}
\usage{
kpmt(pop, obs = NULL, med = NULL, size = NULL, tail = "two-sided",
  verbose = FALSE)
}
\arguments{
\item{pop}{[data frame, matrix, vector] numeric values for the whole population.
If a data frame or matrix is given, it should have format:
\itemize{
    \item{rownames}  {= population member names (e.g. gene names)}
    \item{colnames}  {= features to test (e.g. relative codon usage, UTR length, MFE, etc.)}
}
For a data frame or matrix, the test will be performed on each column, separately.
If a named vector is given, it should have format:
\itemize{
    \item{names} {= population member names.}
    \item{values} {= numeric values of the feature.}
}}

\item{obs}{[character vector or named list of character vectors]
     a character vector of population member names, or a named list of character vectors of population member names.
\enumerate{
    \item  If obs is a list, then each list element name should correspond to a feature name of pop.
    \item  If obs is a vector, then it is considered to be the same sample for each population feature.
    \item  if size = NULL, then obs is considered to be a sample of population member names
    \item  if size is non-NULL, then obs is considered to be the observed
        median values per column of pop. (length obs must be equal to number of features in pop)
}}

\item{med}{[number or vector] pre-computed minimal medians of pop.}

\item{size}{[integer]  size of the set which generated the observed median.  If obs is a sample, i.e. contains
population member names, then size must be NULL.}

\item{tail}{["two-sided", "lower", "upper"]  if NULL, then the minimum of lower and upper will be reported.}

\item{verbose}{display extra messages for tracking execution.}
}
\value{
data frame with columns:
		\itemize{ 
			\item{"name"}  			{a column from pop}
			\item{"median.sample"}		{min median of the sample}
			\item{"median.all"}		{min median of the whole population}
			\item{"median.background"}	{min median of the non-sampled members.}
			\item{"logp"}			{log of p.value if sample median is different from all}
			\item{"p.value"}		{p.value if sample median is different from all}
			\item{"FDR"}			{only if > 30 features, i.e columns of pop}
		}
		each row is a different population feature, i.e. column of pop.
}
\description{
Performs the known population median test.
}
\examples{
data(genefeat)
data(GO0007186)
res  <-  kpmt( pop = genefeat , obs = GO0007186 )
}
