% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/regrXonS.R
\name{regrXonS}
\alias{regrXonS}
\title{Regress set of variables on its parents}
\usage{
regrXonS(X, S)
}
\arguments{
\item{X}{numeric matrix, set of variables to be regressed. Each column represents separate variable}

\item{S}{numeric matrix, set of variables we will regress on. Each column represents separate variable}
}
\value{
regrXonS() returns the residuals of X regressed on S.
}
\description{
Uses the generalised additive model \link{gam} to non-linearly and non-parametrically regress set of variables X on a set of variables S and returns residuals of X.
}
\details{
If the number of variables in S is \eqn{\leq 5}{<= 5} we use \link{frml.full.smooth} as formula for \link{gam} to regress X on S, otherwise we use \link{frml.additive.smooth}.
}
\examples{
set.seed(10)
library(energy)
z <- 10*runif(300)
w <- 10*runif(300)
x <- sin(z) + runif(300)
y <- cos(z) + runif(300)
data <- cbind(x,y,z,w)

hsic.gamma(x,y)
hsic.perm(x,y)
dcov.test(x,y)

resid <- regrXonS(cbind(x,y),cbind(z,w))

hsic.gamma(resid[,1],resid[,2])
hsic.perm(resid[,1],resid[,2])
dcov.test(resid[,1],resid[,2])
}
\author{
Petras Verbyla (\email{petras.verbyla@mrc-bsu.cam.ac.uk})
}
\seealso{
\link{kernelCItest}
}

