% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/knn_next.R
\name{knn_next}
\alias{knn_next}
\title{Next value prediction}
\usage{
knn_next(y, k, d, v = 1, distance_metric = "euclidean",
  weight = "proximity", threads = NULL)
}
\arguments{
\item{y}{A time series.}

\item{k}{Number of neighbors.}

\item{d}{Length of each of the 'elements'.}

\item{v}{Variable to be predicted if given multivariate time series.}

\item{distance_metric}{Type of metric to evaluate the distance between points. Many metrics are supported: euclidean, manhattan,
dynamic time warping, canberra and others. For more information about the supported metrics check the values that 'method'
argument of function 'parDist' (from 'parallelDist' package) can take as this is the function used to calculate the distances.
Link to the package info: \url{https://cran.r-project.org/package=parallelDist}.
Some of the values that this argument can take are "euclidean", "manhattan", "dtw", "canberra", "chord".}

\item{weight}{Type of weight to be used at the time of calculating the predicted value with a weighted mean.
Three supported: proximity, same, linear.
\describe{
  \item{proximity}{the weight assigned to each neighbor is proportional to its distance}
  \item{same}{all neighbors are assigned with the same weight}
  \item{linear}{nearest neighbor is assigned with weight k, second closest neighbor with weight k-1, and so on until the
               least nearest neighbor which is assigned with a weight of 1.}
}}

\item{threads}{Number of threads to be used when parallelizing distances calculation, default is number of cores detected - 1 or
1 if there is only one core.}
}
\value{
The predicted value.
}
\description{
Predicts next value of the time series using k-nearest neighbors algorithm.
}
\examples{
knn_next(AirPassengers, 5, 2, threads = 2)
knn_next(LakeHuron, 3, 6, threads = 2)
}
