% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/UpdateKlass.R
\name{update_code}
\alias{update_code}
\title{Update a code found in a directed graph based on a Klass-classification}
\usage{
update_code(
  graph,
  code,
  date = NA,
  output = "code",
  combine = TRUE,
  report = FALSE
)
}
\arguments{
\item{graph}{A graph generated by \code{\link{klass_graph}}.}

\item{code}{A Klass code}

\item{date}{Optional. The specific date the supplied code is valid in.}

\item{output}{Either a character vector, containing one or more of the items
  in the list below, or \code{TRUE} to include all columns.

  \describe{
   \item{\code{"code"}}{The Klass code.}
   \item{\code{"name"}}{The Klass name.}
   \item{\code{"validFrom"}}{The date that the code is valid from.}
   \item{\code{"validTo"}}{The date that the code is valid to.}
   \item{\code{"split"}}{Logical: Does the code split into two or more codes?}
   \item{\code{"combined"}}{Logical: Does two or more codes become this code?}
   \item{\code{"nextCode"}}{If \code{split == FALSE}, gives the code this code changed into. \code{NA} otherwise.}
  }}

\item{combine}{\code{TRUE} or \code{FALSE}. See the return section.}

\item{report}{\code{TRUE} or \code{FALSE}. See the return section.}
}
\value{
If \code{report == TRUE} and \code{length(output) > 1 | TRUE}, the
  result will be a \code{data.frame} with number of rows equal to the number
  of codes in the sequence of changes between the input code and output code.
  The columns in the \code{data.frame} are specified with \code{output}.

  If \code{report == TRUE} and \code{length(output) == 1}, the result will be
  a character vector with length equal to the number of codes in the sequence
  of changes between the input code and output code. The contents of the
  character vector is specified with \code{output}.

  If \code{report == FALSE} and \code{length(output) > 1 | TRUE} the result
  will be a \code{data.frame} with one row representing the last code
  in the change sequence and columns specified by \code{output}. If a code
  has been split, the result will be \code{NA}. If \code{combine == FALSE}
  and a code is the result of a combination of codes, the result will be
  \code{NA}.

  If \code{report == FALSE} and \code{length(output) == 1}, the result will
  be a character vector of length one, containing information about the
  updated code specified by \code{output}. If a code has been split, the
  result will be \code{NA}. If \code{combine == FALSE} and a code is the
  result of a combination of codes, the result will be \code{NA}.
}
\description{
Update a code found in a directed graph based on a Klass-classification
}
\seealso{
See [update_klass] for updating multiple codes in one function call.
}
