% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/merge_data_tables.R
\name{merge_data_tables}
\alias{merge_data_tables}
\title{Merge data tables}
\usage{
merge_data_tables(dt1 = NULL, dt2 = NULL, id = NULL, silent = TRUE)
}
\arguments{
\item{dt1}{the first data.table which will remain intact}

\item{dt2}{the second data.table which will be joined outside of
(around) the first data.table. If there are any duplicated
ID values and column names across the two data tables, the
cell values in the first data.table will remain intact and
the cell values in the second data.table will be discarded for the
resulting merged data table.}

\item{id}{name of the column that will contain the ID values
in the two data tables. The name of the ID column must be identical
in the two data tables.}

\item{silent}{If \code{silent = TRUE}, no message will be printed
regarding how many ID values and column names were duplicated.
If \code{silent = FALSE}, messages will be printed regarding
how many ID values and column names were duplicated. (default = FALSE)}
}
\value{
a data.table object, which merges (joins) the second data.table
around the first data.table.
}
\description{
Merge two data.table objects. If there are any duplicated
ID values and column names across the two data tables, the
cell values in the first data.table will remain intact and
the cell values in the second data.table will be discarded for the
resulting merged data table.
}
\examples{
data_1 <- data.table::data.table(
id_col = c(4, 2, 1, 3),
a = 3:6,
b = 5:8,
c = c("w", "x", "y", "z"))
data_2 <- data.table::data.table(
id_col = c(1, 4, 99),
d = 6:8,
b = c("p", "q", "r"),
e = c(TRUE, FALSE, FALSE))
merge_data_tables(dt1 = data_1, dt2 = data_2, id = "id_col")
}
