% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/keypress.R
\name{keypress}
\alias{keypress}
\title{Read a single keypress at the terminal}
\usage{
keypress(block = TRUE)
}
\arguments{
\item{block}{Whether to wait for a key press, if there is none
available now.}
}
\value{
The key pressed, a character scalar. For non-blocking reads
NA is returned if no keys are available.
}
\description{
It currently only works at Linux/Unix and OSX terminals,
and at the Windows command line. see \code{\link{has_keypress_support}}.

\if{html}{\out{<link rel="stylesheet" type="text/css" href="../doc/assets/extra.css">}}

\if{html}{\out{<script src="../doc/assets/rd.js"></script>}}
}
\details{
The following special keys are supported:
\itemize{
\item Arrow keys: 'up', 'down', 'right', 'left'.
\item Function keys: from 'f1' to 'f12'.
\item Others: 'home', 'end', 'insert', 'delete', 'pageup', 'pagedown',
'tab', 'enter', 'backspace' (same as 'delete' on OSX keyboards),
'escape'.
\item Control with one of the following keys: 'a', 'b', 'c', 'd', 'e', 'f',
'h', 'k', 'l', 'n', 'p', 't', 'u', 'w'.
}
}
\examples{
\dontshow{if (FALSE) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
x <- keypress()
cat("You pressed key", x, "\n")
\dontshow{\}) # examplesIf}
}
\seealso{
Other keypress function: 
\code{\link{has_keypress_support}()}
}
\concept{keypress function}
