% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/kernel_study.R
\name{heatK}
\alias{heatK}
\title{Kernel matrix heatmap}
\usage{
heatK(
  K,
  cos.norm = FALSE,
  title = NULL,
  color = c("red", "yellow"),
  raster = FALSE
)
}
\arguments{
\item{K}{Kernel matrix (class "matrix").}

\item{cos.norm}{If TRUE, the cosine normalization is applied to the kernel matrix
so its elements have a maximum value of 1. (Defaults: FALSE).}

\item{title}{Heatmap title (optional).}

\item{color}{A vector of length 2 containing two colors. The first color will be
used to represent the minimum value and the second the maximum value of the kernel matrix.}

\item{raster}{In large kernel matrices, raster = TRUE will draw quicker and
better-looking heatmaps. (Defaults=FALSE).}
}
\value{
A `ggplot2` heatmap.
}
\description{
`heatK()` plots the heatmap of a kernel matrix.
}
\examples{
data <- matrix(rnorm(150),ncol=50,nrow=30)
K <- Linear(data)
heatK(K)
}
