% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/kernel_functions.R
\name{Dirac}
\alias{Dirac}
\title{Kernels for categorical variables}
\usage{
Dirac(X, comp = "mean", coeff = NULL, feat_space = FALSE)
}
\arguments{
\item{X}{Matrix (class "character") or data.frame (class "character", or columns = "factor").
The elements in X are assumed to be categorical in nature.}

\item{comp}{When \emph{D}>1, this argument indicates how the variables
of the dataset are combined. Options are: "mean", "sum" and "weighted". (Defaults: "mean")
\itemize{
  \item "sum" gives the same importance to all variables, and returns an
  unnormalized kernel matrix.
  \item "mean" gives the same importance to all variables, and returns a
  normalized kernel matrix (all its elements range between 0 and 1).
  \item "weighted" weights each variable according to the `coeff` parameter, and returns a
  normalized kernel matrix.
}}

\item{coeff}{(optional) A vector of weights with length \emph{D}.}

\item{feat_space}{If FALSE, only the kernel matrix is returned. Otherwise,
the feature space is also returned. (Defaults: FALSE).}
}
\value{
Kernel matrix (dimension: \emph{NxN}), or a list with the kernel matrix and the
feature space.
}
\description{
From a matrix or data.frame with dimension \emph{NxD}, where \emph{N}>1, \emph{D}>0,
`Dirac()` computes the simplest kernel for categorical data. Samples
should be in the rows and features in the columns. When there is a single feature,
`Dirac()` returns 1 if the category (or class, or level) is the same in
two given samples, and 0 otherwise. Instead, when \emph{D}>1, the results for the
\emph{D} features are combined doing a sum, a mean, or a weighted mean.
}
\examples{
# Categorical data
summary(CO2)
Kdirac <- Dirac(CO2[,1:3])
## Display a subset of the kernel matrix:
Kdirac[c(1,15,50,65),c(1,15,50,65)]
}
\references{
Belanche, L. A., and Villegas, M. A. (2013).
Kernel functions for categorical variables with application to problems in the life sciences.
Artificial Intelligence Research and Development (pp. 171-180). IOS Press.
\href{https://upcommons.upc.edu/bitstream/handle/2117/23347/KernelCATEG_CCIA2013.pdf}{Link}
}
