% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/kernel_functions.R
\name{Linear}
\alias{Linear}
\title{Linear kernel}
\usage{
Linear(X, cos.norm = FALSE, coeff = NULL)
}
\arguments{
\item{X}{Matrix or data.frame that contains real numbers ("integer", "float" or "double").}

\item{cos.norm}{Should the resulting kernel matrix be cosine normalized? (Defaults: FALSE).}

\item{coeff}{(optional) A vector of length \emph{D} that weights each one of the
features (columns). When cos.norm=TRUE, `Linear()` first does the weighting and
then the cosine-normalization.}
}
\value{
Kernel matrix (dimension: \emph{NxN}).
}
\description{
`Linear()` computes the inner product between all possible pairs of rows of a
matrix or data.frame with dimension \emph{NxD}.
}
\examples{
dat <- matrix(rnorm(250),ncol=50,nrow=5)
Linear(dat)
}
