% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/kernel_functions.R
\name{Frobenius}
\alias{Frobenius}
\title{Frobenius kernel}
\usage{
Frobenius(DATA, cos.norm = FALSE, feat_space = FALSE)
}
\arguments{
\item{DATA}{A list of \emph{M} matrices or data.frames containing only real
numbers (class "integer", "float" or "double").
All matrices or data.frames should have the same number of rows and columns.}

\item{cos.norm}{Should the resulting kernel matrix be cosine normalized? (Defaults: FALSE).}

\item{feat_space}{If FALSE, only the kernel matrix is returned. Otherwise,
the feature space is also returned. (Defaults: FALSE).}
}
\value{
Kernel matrix (dimension:\emph{NxN}), or a list with the kernel matrix and the
feature space.
}
\description{
`Frobenius()` computes the Frobenius kernel between numeric matrices.
}
\details{
The Frobenius kernel is the same than the Frobenius inner product between
matrices.
}
\examples{

data1 <- matrix(rnorm(250000),ncol=500,nrow=500)
data2 <- matrix(rnorm(250000),ncol=500,nrow=500)
data3 <- matrix(rnorm(250000),ncol=500,nrow=500)

Frobenius(list(data1,data2,data3))
}
