% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/q1CompSymm.R
\name{q1CompSymm}
\alias{q1CompSymm}
\title{
  Qualitative Correlation or Covariance Kernel with one Input and
  Compound Symmetric Correlation
}
\usage{

q1CompSymm(factor, input = "x", cov = c("corr", "homo"))

}
\arguments{
  \item{factor}{

    A factor with the wanted levels for the covariance kernel object.

  }
  \item{input}{

    Name of (qualitative) input for the kernel.

  }
  \item{cov}{.

    Character telling if the kernel is a correlation kernel or a
    homoscedastic covariance kernel.

  }
}
\value{
  
  An object with class \code{"covQual"} with \code{d = 1}
  qualitative input.

}
\description{

  Qualitative correlation or covariance kernel with one input and
  compound symmetric correlation.

}
\note{

  Correlation kernels are needed in tensor products because
  the tensor product of two covariance kernels each with unknown
  variance would not be identifiable.

}
\examples{
School <- factor(1L:3L, labels = c("Bad", "Mean" , "Good"))
myCor <- q1CompSymm(School, input = "School")
coef(myCor) <- 0.26

## Use a data.frame with a factor
set.seed(246)
newSchool <- factor(sample(1L:3L, size = 20, replace = TRUE),
                    labels = c("Bad", "Mean" , "Good"))
C1 <- covMat(myCor, X = data.frame(School = newSchool),
             compGrad = FALSE, lowerSQRT = FALSE)

## or use a matrix with integer content
C2 <- covMat(myCor, X = cbind(School = as.integer(newSchool)),
             compGrad = FALSE, lowerSQRT = FALSE)
max(abs(C1 - C2))
}
\seealso{
  
  The \code{\link{corLevCompSymm}} function used to compute
  the correlation matrix and its gradients w.r.t. the correlation
  parameters.

}
