% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dataset-utils.R
\name{image_dataset_from_directory}
\alias{image_dataset_from_directory}
\title{Generates a \code{tf.data.Dataset} from image files in a directory.}
\usage{
image_dataset_from_directory(
  directory,
  labels = "inferred",
  label_mode = "int",
  class_names = NULL,
  color_mode = "rgb",
  batch_size = 32L,
  image_size = c(256L, 256L),
  shuffle = TRUE,
  seed = NULL,
  validation_split = NULL,
  subset = NULL,
  interpolation = "bilinear",
  follow_links = FALSE,
  crop_to_aspect_ratio = FALSE,
  pad_to_aspect_ratio = FALSE,
  data_format = NULL,
  verbose = TRUE
)
}
\arguments{
\item{directory}{Directory where the data is located.
If \code{labels} is \code{"inferred"}, it should contain
subdirectories, each containing images for a class.
Otherwise, the directory structure is ignored.}

\item{labels}{Either \code{"inferred"}
(labels are generated from the directory structure),
\code{NULL} (no labels),
or a list/tuple of integer labels of the same size as the number of
image files found in the directory. Labels should be sorted
according to the alphanumeric order of the image file paths
(obtained via \code{os.walk(directory)} in Python).}

\item{label_mode}{String describing the encoding of \code{labels}. Options are:
\itemize{
\item \code{"int"}: means that the labels are encoded as integers
(e.g. for \code{sparse_categorical_crossentropy} loss).
\item \code{"categorical"} means that the labels are
encoded as a categorical vector
(e.g. for \code{categorical_crossentropy} loss).
\item \code{"binary"} means that the labels (there can be only 2)
are encoded as \code{float32} scalars with values 0 or 1
(e.g. for \code{binary_crossentropy}).
\item \code{NULL} (no labels).
}}

\item{class_names}{Only valid if \code{labels} is \code{"inferred"}.
This is the explicit list of class names
(must match names of subdirectories). Used to control the order
of the classes (otherwise alphanumerical order is used).}

\item{color_mode}{One of \code{"grayscale"}, \code{"rgb"}, \code{"rgba"}.
Whether the images will be converted to
have 1, 3, or 4 channels. Defaults to \code{"rgb"}.}

\item{batch_size}{Size of the batches of data. Defaults to 32.
If \code{NULL}, the data will not be batched
(the dataset will yield individual samples).}

\item{image_size}{Size to resize images to after they are read from disk,
specified as \verb{(height, width)}.
Since the pipeline processes batches of images that must all have
the same size, this must be provided. Defaults to \verb{(256, 256)}.}

\item{shuffle}{Whether to shuffle the data. Defaults to \code{TRUE}.
If set to \code{FALSE}, sorts the data in alphanumeric order.}

\item{seed}{Optional random seed for shuffling and transformations.}

\item{validation_split}{Optional float between 0 and 1,
fraction of data to reserve for validation.}

\item{subset}{Subset of the data to return.
One of \code{"training"}, \code{"validation"}, or \code{"both"}.
Only used if \code{validation_split} is set.
When \code{subset = "both"}, the utility returns a tuple of two datasets
(the training and validation datasets respectively).}

\item{interpolation}{String, the interpolation method used when
resizing images.
Supports \code{"bilinear"}, \code{"nearest"}, \code{"bicubic"}, \code{"area"},
\code{"lanczos3"}, \code{"lanczos5"}, \code{"gaussian"}, \code{"mitchellcubic"}.
Defaults to \code{"bilinear"}.}

\item{follow_links}{Whether to visit subdirectories pointed to by symlinks.
Defaults to \code{FALSE}.}

\item{crop_to_aspect_ratio}{If \code{TRUE}, resize the images without aspect
ratio distortion. When the original aspect ratio differs from the
target aspect ratio, the output image will be cropped so as to
return the largest possible window in the image
(of size \code{image_size}) that matches the target aspect ratio. By
default (\code{crop_to_aspect_ratio = FALSE}), aspect ratio may not be
preserved.}

\item{pad_to_aspect_ratio}{If \code{TRUE}, resize the images without aspect
ratio distortion. When the original aspect ratio differs from the
target aspect ratio, the output image will be padded so as to
return the largest possible window in the image
(of size \code{image_size}) that matches the target aspect ratio. By
default (\code{pad_to_aspect_ratio=FALSE}), aspect ratio may not be
preserved.}

\item{data_format}{If \code{NULL} uses \code{\link[=config_image_data_format]{config_image_data_format()}}
otherwise either \code{'channel_last'} or \code{'channel_first'}.}

\item{verbose}{Whether to display number information on classes and
number of files found. Defaults to \code{TRUE}.}
}
\value{
A \code{tf.data.Dataset} object.
\itemize{
\item If \code{label_mode} is \code{NULL}, it yields \code{float32} tensors of shape
\verb{(batch_size, image_size[1], image_size[2], num_channels)},
encoding images (see below for rules regarding \code{num_channels}).
\item Otherwise, it yields a tuple \verb{(images, labels)}, where \code{images} has
shape \verb{(batch_size, image_size[1], image_size[2], num_channels)},
and \code{labels} follows the format described below.
}

Rules regarding labels format:
\itemize{
\item if \code{label_mode} is \code{"int"}, the labels are an \code{int32} tensor of shape
\verb{(batch_size,)}.
\item if \code{label_mode} is \code{"binary"}, the labels are a \code{float32} tensor of
1s and 0s of shape \verb{(batch_size, 1)}.
\item if \code{label_mode} is \code{"categorical"}, the labels are a \code{float32} tensor
of shape \verb{(batch_size, num_classes)}, representing a one-hot
encoding of the class index.
}

Rules regarding number of channels in the yielded images:
\itemize{
\item if \code{color_mode} is \code{"grayscale"},
there's 1 channel in the image tensors.
\item if \code{color_mode} is \code{"rgb"},
there are 3 channels in the image tensors.
\item if \code{color_mode} is \code{"rgba"},
there are 4 channels in the image tensors.
}
}
\description{
If your directory structure is:

\if{html}{\out{<div class="sourceCode">}}\preformatted{main_directory/
...class_a/
......a_image_1.jpg
......a_image_2.jpg
...class_b/
......b_image_1.jpg
......b_image_2.jpg
}\if{html}{\out{</div>}}

Then calling \code{image_dataset_from_directory(main_directory, labels = 'inferred')} will return a \code{tf.data.Dataset} that yields batches of
images from the subdirectories \code{class_a} and \code{class_b}, together with labels
0 and 1 (0 corresponding to \code{class_a} and 1 corresponding to \code{class_b}).

Supported image formats: \code{.jpeg}, \code{.jpg}, \code{.png}, \code{.bmp}, \code{.gif}.
Animated gifs are truncated to the first frame.
}
\seealso{
\itemize{
\item \url{https://keras.io/api/data_loading/image#imagedatasetfromdirectory-function}
}

Other dataset utils: \cr
\code{\link{audio_dataset_from_directory}()} \cr
\code{\link{split_dataset}()} \cr
\code{\link{text_dataset_from_directory}()} \cr
\code{\link{timeseries_dataset_from_array}()} \cr

Other utils: \cr
\code{\link{audio_dataset_from_directory}()} \cr
\code{\link{clear_session}()} \cr
\code{\link{config_disable_interactive_logging}()} \cr
\code{\link{config_disable_traceback_filtering}()} \cr
\code{\link{config_enable_interactive_logging}()} \cr
\code{\link{config_enable_traceback_filtering}()} \cr
\code{\link{config_is_interactive_logging_enabled}()} \cr
\code{\link{config_is_traceback_filtering_enabled}()} \cr
\code{\link{get_file}()} \cr
\code{\link{get_source_inputs}()} \cr
\code{\link{image_array_save}()} \cr
\code{\link{image_from_array}()} \cr
\code{\link{image_load}()} \cr
\code{\link{image_smart_resize}()} \cr
\code{\link{image_to_array}()} \cr
\code{\link{layer_feature_space}()} \cr
\code{\link{normalize}()} \cr
\code{\link{pad_sequences}()} \cr
\code{\link{set_random_seed}()} \cr
\code{\link{split_dataset}()} \cr
\code{\link{text_dataset_from_directory}()} \cr
\code{\link{timeseries_dataset_from_array}()} \cr
\code{\link{to_categorical}()} \cr
\code{\link{zip_lists}()} \cr

Other preprocessing: \cr
\code{\link{image_smart_resize}()} \cr
\code{\link{text_dataset_from_directory}()} \cr
\code{\link{timeseries_dataset_from_array}()} \cr
}
\concept{dataset utils}
\concept{image dataset utils}
\concept{preprocessing}
\concept{utils}
