% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/initializers.R
\name{initializer_variance_scaling}
\alias{initializer_variance_scaling}
\title{Initializer that adapts its scale to the shape of its input tensors.}
\usage{
initializer_variance_scaling(
  scale = 1,
  mode = "fan_in",
  distribution = "truncated_normal",
  seed = NULL
)
}
\arguments{
\item{scale}{Scaling factor (positive float).}

\item{mode}{One of \code{"fan_in"}, \code{"fan_out"}, \code{"fan_avg"}.}

\item{distribution}{Random distribution to use.
One of \code{"truncated_normal"}, \code{"untruncated_normal"}, or \code{"uniform"}.}

\item{seed}{An integer or instance of
\code{random_seed_generator()}.
Used to make the behavior of the initializer
deterministic. Note that an initializer seeded with an integer
or \code{NULL} (unseeded) will produce the same random values
across multiple calls. To get different random values
across multiple calls, use as seed an instance
of \code{random_seed_generator()}.}
}
\value{
An \code{Initializer} instance that can be passed to layer or variable
constructors, or called directly with a \code{shape} to return a Tensor.
}
\description{
With \verb{distribution = "truncated_normal" or "untruncated_normal"}, samples are
drawn from a truncated/untruncated normal distribution with a mean of zero
and a standard deviation (after truncation, if used) \code{stddev = sqrt(scale / n)}, where \code{n} is:
\itemize{
\item number of input units in the weight tensor, if \code{mode = "fan_in"}
\item number of output units, if \code{mode = "fan_out"}
\item average of the numbers of input and output units, if \code{mode = "fan_avg"}
}

With \code{distribution = "uniform"}, samples are drawn from a uniform distribution
within \verb{[-limit, limit]}, where \code{limit = sqrt(3 * scale / n)}.
}
\section{Examples}{
\if{html}{\out{<div class="sourceCode r">}}\preformatted{# Standalone usage:
initializer <- initializer_variance_scaling(scale = 0.1, mode = 'fan_in',
                                            distribution = 'uniform')
values <- initializer(shape = c(2, 2))
}\if{html}{\out{</div>}}

\if{html}{\out{<div class="sourceCode r">}}\preformatted{# Usage in a Keras layer:
initializer <- initializer_variance_scaling(scale = 0.1, mode = 'fan_in',
                                            distribution = 'uniform')
layer <- layer_dense(units = 3, kernel_initializer = initializer)
}\if{html}{\out{</div>}}
}

\seealso{
\itemize{
\item \url{https://keras.io/api/layers/initializers#variancescaling-class}
}

Other random initializers: \cr
\code{\link{initializer_glorot_normal}()} \cr
\code{\link{initializer_glorot_uniform}()} \cr
\code{\link{initializer_he_normal}()} \cr
\code{\link{initializer_he_uniform}()} \cr
\code{\link{initializer_lecun_normal}()} \cr
\code{\link{initializer_lecun_uniform}()} \cr
\code{\link{initializer_orthogonal}()} \cr
\code{\link{initializer_random_normal}()} \cr
\code{\link{initializer_random_uniform}()} \cr
\code{\link{initializer_truncated_normal}()} \cr

Other initializers: \cr
\code{\link{initializer_constant}()} \cr
\code{\link{initializer_glorot_normal}()} \cr
\code{\link{initializer_glorot_uniform}()} \cr
\code{\link{initializer_he_normal}()} \cr
\code{\link{initializer_he_uniform}()} \cr
\code{\link{initializer_identity}()} \cr
\code{\link{initializer_lecun_normal}()} \cr
\code{\link{initializer_lecun_uniform}()} \cr
\code{\link{initializer_ones}()} \cr
\code{\link{initializer_orthogonal}()} \cr
\code{\link{initializer_random_normal}()} \cr
\code{\link{initializer_random_uniform}()} \cr
\code{\link{initializer_truncated_normal}()} \cr
\code{\link{initializer_zeros}()} \cr
}
\concept{initializers}
\concept{random initializers}
