% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/model-creation.R
\name{keras_input}
\alias{keras_input}
\title{Create a Keras tensor (Functional API input).}
\usage{
keras_input(
  shape = NULL,
  batch_size = NULL,
  dtype = NULL,
  sparse = NULL,
  batch_shape = NULL,
  name = NULL,
  tensor = NULL,
  optional = FALSE
)
}
\arguments{
\item{shape}{A shape list (list of integers or \code{NULL} objects),
not including the batch size.
For instance, \code{shape = c(32)} indicates that the expected input
will be batches of 32-dimensional vectors. Elements of this list
can be \code{NULL} or \code{NA}; \code{NULL}/\code{NA} elements represent dimensions where the shape
is not known and may vary (e.g. sequence length).}

\item{batch_size}{Optional static batch size (integer).}

\item{dtype}{The data type expected by the input, as a string
(e.g. \code{"float32"}, \code{"int32"}...)}

\item{sparse}{A boolean specifying whether the expected input will be sparse
tensors. Note that, if \code{sparse} is \code{FALSE}, sparse tensors can still
be passed into the input - they will be densified with a default
value of 0. This feature is only supported with the TensorFlow
backend. Defaults to \code{FALSE}.}

\item{batch_shape}{Shape, including the batch dim.}

\item{name}{Optional name string for the layer.
Should be unique in a model (do not reuse the same name twice).
It will be autogenerated if it isn't provided.}

\item{tensor}{Optional existing tensor to wrap into the \code{Input} layer.
If set, the layer will use this tensor rather
than creating a new placeholder tensor.}

\item{optional}{Boolean, whether the input is optional or not.
An optional input can accept \code{NULL} values.}
}
\value{
A Keras tensor,
which can passed to the \code{inputs} argument of (\code{\link[=keras_model]{keras_model()}}).
}
\description{
A Keras tensor is a symbolic tensor-like object, which we augment with
certain attributes that allow us to build a Keras model just by knowing the
inputs and outputs of the model.

For instance, if \code{a}, \code{b} and \code{c} are Keras tensors,
it becomes possible to do:
\code{model <- keras_model(input = c(a, b), output = c)}
}
\section{Examples}{
\if{html}{\out{<div class="sourceCode r">}}\preformatted{# This is a logistic regression in Keras
input <- layer_input(shape=c(32))
output <- input |> layer_dense(16, activation='softmax')
model <- keras_model(input, output)
}\if{html}{\out{</div>}}
}

\seealso{
Other model creation: \cr
\code{\link{keras_model}()} \cr
\code{\link{keras_model_sequential}()} \cr
}
\concept{model creation}
