% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/layers-activations.R
\name{layer_activation_selu}
\alias{layer_activation_selu}
\title{Scaled Exponential Linear Unit.}
\usage{
layer_activation_selu(
  object,
  input_shape = NULL,
  batch_input_shape = NULL,
  batch_size = NULL,
  dtype = NULL,
  name = NULL,
  trainable = NULL,
  weights = NULL
)
}
\arguments{
\item{object}{What to compose the new \code{Layer} instance with. Typically a
Sequential model or a Tensor (e.g., as returned by \code{layer_input()}).
The return value depends on \code{object}. If \code{object} is:
\itemize{
\item missing or \code{NULL}, the \code{Layer} instance is returned.
\item a \code{Sequential} model, the model with an additional layer is returned.
\item a Tensor, the output tensor from \code{layer_instance(object)} is returned.
}}

\item{input_shape}{Input shape (list of integers, does not include the
samples axis) which is required when using this layer as the first layer in
a model.}

\item{batch_input_shape}{Shapes, including the batch size. For instance,
\code{batch_input_shape=c(10, 32)} indicates that the expected input will be
batches of 10 32-dimensional vectors. \code{batch_input_shape=list(NULL, 32)}
indicates batches of an arbitrary number of 32-dimensional vectors.}

\item{batch_size}{Fixed batch size for layer}

\item{dtype}{The data type expected by the input, as a string (\code{float32},
\code{float64}, \code{int32}...)}

\item{name}{An optional name string for the layer. Should be unique in a
model (do not reuse the same name twice). It will be autogenerated if it
isn't provided.}

\item{trainable}{Whether the layer weights will be updated during training.}

\item{weights}{Initial weights for layer.}
}
\description{
SELU is equal to: \code{scale * elu(x, alpha)}, where alpha and scale
are pre-defined constants.
}
\details{
The values of \code{alpha} and \code{scale} are
chosen so that the mean and variance of the inputs are preserved
between two consecutive layers as long as the weights are initialized
correctly (see initializer_lecun_normal) and the number of inputs
is "large enough" (see article for more information).

Note:
\itemize{
\item To be used together with the initialization "lecun_normal".
\item To be used together with the dropout variant "AlphaDropout".
}
}
\seealso{
\href{https://arxiv.org/abs/1706.02515}{Self-Normalizing Neural Networks}, \code{\link{initializer_lecun_normal}}, \code{\link{layer_alpha_dropout}}

Other activation layers: 
\code{\link{layer_activation_elu}()},
\code{\link{layer_activation_leaky_relu}()},
\code{\link{layer_activation_parametric_relu}()},
\code{\link{layer_activation_relu}()},
\code{\link{layer_activation_softmax}()},
\code{\link{layer_activation_thresholded_relu}()},
\code{\link{layer_activation}()}
}
\concept{activation layers}
