% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/py-classes.R
\name{\%py_class\%}
\alias{\%py_class\%}
\alias{py_class}
\title{Make a python class constructor}
\usage{
spec \%py_class\% body
}
\arguments{
\item{spec}{a bare symbol \code{MyClassName}, or a call \code{MyClassName(SuperClass)}}

\item{body}{an expression that can be evaluated to construct the class
methods.}
}
\value{
The python class constructor, invisibly. Note, the same constructor is
also assigned in the parent frame.
}
\description{
Make a python class constructor
}
\examples{
\dontrun{
MyClass \%py_class\% {
  initialize <- function(x) {
    print("Hi from MyClass$initialize()!")
    self$x <- x
  }
  my_method <- function() {
    self$x
  }
}

my_class_instance <- MyClass(42)
my_class_instance$my_method()

MyClass2(MyClass) \%py_class\% {
  "This will be a __doc__ string for MyClass2"

  initialize <- function(...) {
    "This will be the __doc__ string for the MyClass2.__init__() method"
    print("Hi from MyClass2$initialize()!")
    super$initialize(...)
  }
}

my_class_instance2 <- MyClass2(42)
my_class_instance2$my_method()

reticulate::py_help(MyClass2) # see the __doc__ strings and more!
}
}
