% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/applications.R
\name{application_inception_resnet_v2}
\alias{application_inception_resnet_v2}
\alias{inception_resnet_v2_preprocess_input}
\title{Inception-ResNet v2 model, with weights trained on ImageNet}
\usage{
application_inception_resnet_v2(
  include_top = TRUE,
  weights = "imagenet",
  input_tensor = NULL,
  input_shape = NULL,
  pooling = NULL,
  classes = 1000
)

inception_resnet_v2_preprocess_input(x)
}
\arguments{
\item{include_top}{whether to include the fully-connected layer at the top of
the network.}

\item{weights}{\code{NULL} (random initialization), \code{imagenet} (ImageNet
weights), or the path to the weights file to be loaded.}

\item{input_tensor}{optional Keras tensor to use as image input for the
model.}

\item{input_shape}{optional shape list, only to be specified if \code{include_top}
is FALSE (otherwise the input shape has to be \verb{(299, 299, 3)}. It should
have exactly 3 inputs channels, and width and height should be no smaller
than 75. E.g. \verb{(150, 150, 3)} would be one valid value.}

\item{pooling}{Optional pooling mode for feature extraction when
\code{include_top} is \code{FALSE}.
\itemize{
\item \code{NULL} means that the output of the model will be the 4D tensor output
of the last convolutional layer.
\item \code{avg} means that global average pooling will be applied to the output of
the last convolutional layer, and thus the output of the model will be
a 2D tensor.
\item \code{max} means that global max pooling will be applied.
}}

\item{classes}{optional number of classes to classify images into, only to be
specified if \code{include_top} is TRUE, and if no \code{weights} argument is
specified.}

\item{x}{Input tensor for preprocessing}
}
\value{
A Keras model instance.
}
\description{
Inception-ResNet v2 model, with weights trained on ImageNet
}
\details{
Do note that the input image format for this model is different than for
the VGG16 and ResNet models (299x299 instead of 224x224).

The \code{inception_resnet_v2_preprocess_input()} function should be used for image
preprocessing.
}
\section{Reference}{

\itemize{
\item \href{https://arxiv.org/abs/1602.07261}{Inception-v4, Inception-ResNet and the Impact of Residual Connections on Learning}(http://arxiv.org/abs/1512.00567)
}
}

