% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/optimizers.R
\name{optimizer_sgd}
\alias{optimizer_sgd}
\title{Stochastic gradient descent optimizer}
\usage{
optimizer_sgd(lr = 0.01, momentum = 0, decay = 0, nesterov = FALSE,
  clipnorm = NULL, clipvalue = NULL)
}
\arguments{
\item{lr}{float >= 0. Learning rate.}

\item{momentum}{float >= 0. Parameter that accelerates SGD in the relevant
direction and dampens oscillations.}

\item{decay}{float >= 0. Learning rate decay over each update.}

\item{nesterov}{boolean. Whether to apply Nesterov momentum.}

\item{clipnorm}{Gradients will be clipped when their L2 norm exceeds this
value.}

\item{clipvalue}{Gradients will be clipped when their absolute value exceeds
this value.}
}
\value{
Optimizer for use with \code{\link{compile.keras.engine.training.Model}}.
}
\description{
Stochastic gradient descent optimizer with support for momentum, learning
rate decay, and Nesterov momentum.
}
\seealso{
Other optimizers: \code{\link{optimizer_adadelta}},
  \code{\link{optimizer_adagrad}},
  \code{\link{optimizer_adamax}},
  \code{\link{optimizer_adam}},
  \code{\link{optimizer_nadam}},
  \code{\link{optimizer_rmsprop}}
}
\concept{optimizers}
