% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/layers-embedding.R
\name{layer_embedding}
\alias{layer_embedding}
\title{Turns positive integers (indexes) into dense vectors of fixed size.}
\usage{
layer_embedding(object, input_dim, output_dim,
  embeddings_initializer = "uniform", embeddings_regularizer = NULL,
  activity_regularizer = NULL, embeddings_constraint = NULL,
  mask_zero = FALSE, input_length = NULL, batch_size = NULL,
  name = NULL, trainable = NULL, weights = NULL)
}
\arguments{
\item{object}{Model or layer object}

\item{input_dim}{int > 0. Size of the vocabulary, i.e. maximum integer
index + 1.}

\item{output_dim}{int >= 0. Dimension of the dense embedding.}

\item{embeddings_initializer}{Initializer for the \code{embeddings} matrix.}

\item{embeddings_regularizer}{Regularizer function applied to the
\code{embeddings} matrix.}

\item{activity_regularizer}{activity_regularizer}

\item{embeddings_constraint}{Constraint function applied to the \code{embeddings}
matrix.}

\item{mask_zero}{Whether or not the input value 0 is a special "padding"
value that should be masked out. This is useful when using recurrent
layers, which may take variable length inputs. If this is \code{TRUE} then all
subsequent layers in the model need to support masking or an exception will
be raised. If mask_zero is set to TRUE, as a consequence, index 0 cannot be
used in the vocabulary (input_dim should equal size of vocabulary + 1).}

\item{input_length}{Length of input sequences, when it is constant. This
argument is required if you are going to connect \code{Flatten} then \code{Dense}
layers upstream (without it, the shape of the dense outputs cannot be
computed).}

\item{batch_size}{Fixed batch size for layer}

\item{name}{An optional name string for the layer. Should be unique in a
model (do not reuse the same name twice). It will be autogenerated if it
isn't provided.}

\item{trainable}{Whether the layer weights will be updated during training.}

\item{weights}{Initial weights for layer.}
}
\description{
For example, \code{list(4L, 20L) -> list(c(0.25, 0.1), c(0.6, -0.2))} This layer
can only be used as the first layer in a model.
}
\section{Input shape}{
 2D tensor with shape: \code{(batch_size, sequence_length)}.
}

\section{Output shape}{
 3D tensor with shape: \code{(batch_size, sequence_length, output_dim)}.
}

\section{References}{

\itemize{
\item \href{http://arxiv.org/abs/1512.05287}{A Theoretically Grounded Application of Dropout in Recurrent Neural Networks}
}
}

