% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/callbacks.R
\name{callback_tensorboard}
\alias{callback_tensorboard}
\title{TensorBoard basic visualizations}
\usage{
callback_tensorboard(log_dir = NULL, histogram_freq = 0, batch_size = 32,
  write_graph = TRUE, write_grads = FALSE, write_images = FALSE,
  embeddings_freq = 0, embeddings_layer_names = NULL,
  embeddings_metadata = NULL)
}
\arguments{
\item{log_dir}{The path of the directory where to save the log files to be
parsed by Tensorboard. The default is \code{NULL}, which will use the active
run directory (if available) and otherwise will use "logs".}

\item{histogram_freq}{frequency (in epochs) at which to compute activation
histograms for the layers of the model. If set to 0, histograms won't be
computed.}

\item{batch_size}{size of batch of inputs to feed to the network
for histograms computation.}

\item{write_graph}{whether to visualize the graph in Tensorboard. The log
file can become quite large when write_graph is set to \code{TRUE}}

\item{write_grads}{whether to visualize gradient histograms in TensorBoard.
\code{histogram_freq} must be greater than 0.}

\item{write_images}{whether to write model weights to visualize as image in
Tensorboard.}

\item{embeddings_freq}{frequency (in epochs) at which selected embedding
layers will be saved.}

\item{embeddings_layer_names}{a list of names of layers to keep eye on. If
\code{NULL} or empty list all the embedding layers will be watched.}

\item{embeddings_metadata}{a named list which maps layer name to a file name in
which metadata for this embedding layer is saved. See the
\href{https://www.tensorflow.org/how_tos/embedding_viz/#metadata_optional}{details}
about the metadata file format. In case if the same metadata file is used
for all embedding layers, string can be passed.}
}
\description{
This callback writes a log for TensorBoard, which allows you to visualize
dynamic graphs of your training and test metrics, as well as activation
histograms for the different layers in your model.
}
\details{
TensorBoard is a visualization tool provided with TensorFlow.

You can find more information about TensorBoard
\href{https://www.tensorflow.org/get_started/summaries_and_tensorboard}{here}.
}
\seealso{
Other callbacks: \code{\link{callback_csv_logger}},
  \code{\link{callback_early_stopping}},
  \code{\link{callback_lambda}},
  \code{\link{callback_learning_rate_scheduler}},
  \code{\link{callback_model_checkpoint}},
  \code{\link{callback_progbar_logger}},
  \code{\link{callback_reduce_lr_on_plateau}},
  \code{\link{callback_remote_monitor}},
  \code{\link{callback_terminate_on_naan}}
}
