% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/kdtools.R
\name{kd_sort}
\alias{kd_sort}
\alias{kd_sort.matrix}
\alias{kd_sort.arrayvec}
\alias{kd_sort.data.frame}
\alias{kd_sort.sf}
\alias{kd_order}
\alias{kd_order.matrix}
\alias{kd_order.arrayvec}
\alias{kd_order.data.frame}
\alias{kd_is_sorted}
\title{Sort multidimensional data}
\usage{
kd_sort(x, ...)

\method{kd_sort}{matrix}(x, cols = NULL, parallel = TRUE, ...)

\method{kd_sort}{arrayvec}(x, inplace = FALSE, parallel = TRUE, ...)

\method{kd_sort}{data.frame}(x, cols = NULL, parallel = TRUE, ...)

\method{kd_sort}{sf}(x, cols = NULL, parallel = TRUE, ...)

kd_order(x, ...)

\method{kd_order}{matrix}(x, cols = NULL, parallel = TRUE, ...)

\method{kd_order}{arrayvec}(x, inplace = FALSE, parallel = TRUE, ...)

\method{kd_order}{data.frame}(x, cols = NULL, parallel = TRUE, ...)

kd_is_sorted(x, ...)
}
\arguments{
\item{x}{a matrix or arrayvec object}

\item{...}{ignored}

\item{cols}{integer vector of column indices}

\item{parallel}{use multiple threads if true}

\item{inplace}{sort as a side-effect if true}
}
\value{
\tabular{ll}{\code{kd_sort} \tab the table sorted in kd-tree order
  \cr \code{kd_order} \tab a permutation vector \cr \code{kd_is_sorted} \tab
  a boolean \cr}
}
\description{
Sort multidimensional data
}
\details{
The algorithm used is a divide-and-conquer quicksort variant that
  recursively partitions an range of tuples using the median of each successive
  dimension. Ties are resolved by cycling over successive dimensions. The
  result is an ordering of tuples matching their order if they were inserted
  into a kd-tree.

  \code{kd_order} returns permutation vector that will order the rows of the
  original matrix, exactly as \code{\link{order}}. If \code{inplace} is true,
  then \code{kd_order} will also sort the arrayvec object as a side effect.
  This can be more efficient when many subsequent queries are required.

  \code{kd_sort} and \code{kd_order} have been extended to work directly on a
  data frame. All vector column types are supported (even lists of objects as
  long as equality and comparison operators are defined). Additional, the
  user can specify a sequence of column indices that will be used for
  sorting. These can be a subset of columns and given in any order.
}
\note{
The matrix version will be slower because of data structure
  conversions.
}
\examples{
if (has_cxx17()) {
z <- data.frame(real = runif(10), lgl = runif(10) > 0.5,
                int = as.integer(rpois(10, 2)), char = sample(month.name, 10),
                stringsAsFactors = FALSE)
kd_sort(z)
x <- matrix(runif(200), 100)
y <- kd_sort(x)
kd_is_sorted(y)
kd_order(x)
plot(y, type = "o", pch = 19, col = "steelblue", asp = 1)
}
}
\seealso{
\code{\link{arrayvec}}
}
