% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/flatten.R
\name{flatten}
\alias{flatten}
\alias{flatten.multipleJustifierElements}
\alias{flatten.singleJustifierElement}
\title{Flatten a justifier tree}
\usage{
flatten(x, ..., recursionLevel = 0, silent = justifier::opts$get("silent"))

\method{flatten}{multipleJustifierElements}(x, ..., recursionLevel = 0, silent = justifier::opts$get("silent"))

\method{flatten}{singleJustifierElement}(x, ..., recursionLevel = 0, silent = justifier::opts$get("silent"))
}
\arguments{
\item{x}{The justifier object or objects.}

\item{...}{Additional arguments are passed to the methods.}

\item{recursionLevel}{The depth of the recursion}

\item{silent}{Whether to be silent or chatty}
}
\value{
A flattened justifier object.
}
\description{
Flattening takes all justifications, assertions, and sources from their
parents and returns a structured justifier object containing these
elements in separate lists, with each occurrence replaced with a reference
to the corresponding identifier.
}
\examples{
### Programmatically create a justification with two assertions
### but without sources
justifierJustification <-
  justifier::justify(
    "Icecream will make me feel less fit",
    assertion = c(
      justifier::assert('Icecream is rich in energy'),
      justifier::assert('Consuming high-energy foods makes me feel less fit')
    ),
    weight = -.5
  );

### Flatten it into a structures justifier object
structuredJustification <-
  justifier::flatten(
    justifierJustification
  );

### Check it
str(structuredJustification, 1);
}
