/*
 * Decompiled with CFR 0.152.
 */
package org.fgilbert.jsr223;

import java.util.concurrent.ArrayBlockingQueue;
import javax.script.Bindings;
import javax.script.CompiledScript;
import javax.script.Invocable;
import javax.script.ScriptEngine;
import org.fgilbert.jdx.JavaToR;
import org.fgilbert.jsr223.Controller;
import org.fgilbert.jsr223.Message;
import org.fgilbert.jsr223.RequestEvaluation;
import org.fgilbert.jsr223.RequestInvokeFunction;
import org.fgilbert.jsr223.RequestInvokeMethod;

class EvaluationThread
implements Runnable {
    private Controller controller;
    private ScriptEngine engine;
    private Invocable invocable;
    private ArrayBlockingQueue<Message> queue = new ArrayBlockingQueue(1);
    private boolean started;
    private Thread thread;

    EvaluationThread(Controller controller, ScriptEngine engine) {
        this.controller = controller;
        this.engine = engine;
        try {
            this.invocable = (Invocable)((Object)engine);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    void eval(RequestEvaluation request) throws InterruptedException {
        try {
            CompiledScript compiledScript = request.getCompiledScript();
            Bindings bindings = request.getBindings();
            Object result = null;
            result = compiledScript == null ? (bindings == null ? this.engine.eval(request.getScript()) : this.engine.eval(request.getScript(), bindings)) : (bindings == null ? compiledScript.eval() : compiledScript.eval(bindings));
            this.controller.putQueueItem(request.getDiscardReturnValue() ? new JavaToR(null) : new JavaToR(result, this.controller.getArrayOrder()));
        }
        catch (Throwable e) {
            this.controller.putQueueItem(new JavaToR((Object)e));
        }
    }

    void invokeFunction(RequestInvokeFunction request) throws InterruptedException {
        try {
            if (this.invocable == null) {
                throw new RuntimeException("The script engine does not support the invocable interface.");
            }
            this.controller.putQueueItem(new JavaToR(this.invocable.invokeFunction(request.getFunctionName(), request.getArguments()), this.controller.getArrayOrder()));
        }
        catch (Throwable e) {
            this.controller.putQueueItem(new JavaToR((Object)e));
        }
    }

    void invokeMethod(RequestInvokeMethod request) throws InterruptedException {
        try {
            if (this.invocable == null) {
                throw new RuntimeException("The script engine does not support the invocable interface.");
            }
            Object object = this.engine.get(request.getObjectName());
            if (object == null) {
                throw new RuntimeException(String.format("An object with identifier '%s' could not be found.", request.getObjectName()));
            }
            this.controller.putQueueItem(new JavaToR(this.invocable.invokeMethod(object, request.getMethodName(), request.getArguments()), this.controller.getArrayOrder()));
        }
        catch (Throwable e) {
            this.controller.putQueueItem(new JavaToR((Object)e));
        }
    }

    Message getQueueItem() throws InterruptedException {
        return this.queue.take();
    }

    boolean isStarted() {
        return this.started;
    }

    void processRequest(Message message) throws InterruptedException {
        switch (message.getSubject()) {
            case RQ_EVALUATE: {
                this.eval((RequestEvaluation)message.getData());
                break;
            }
            case RQ_INVOKE_FUNCTION: {
                this.invokeFunction((RequestInvokeFunction)message.getData());
                break;
            }
            case RQ_INVOKE_METHOD: {
                this.invokeMethod((RequestInvokeMethod)message.getData());
                break;
            }
            default: {
                throw new RuntimeException(String.format("Unexpected message subject '%s'.", new Object[]{message.getSubject()}));
            }
        }
    }

    void putQueueItem(Message message) throws InterruptedException {
        this.queue.put(message);
    }

    @Override
    public void run() {
        Message message = null;
        do {
            try {
                message = this.queue.take();
                this.processRequest(message);
            }
            catch (Throwable e) {
                boolean putComplete = false;
                do {
                    try {
                        this.controller.putQueueItem(new JavaToR((Object)e, this.controller.getArrayOrder()));
                        putComplete = true;
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                } while (!putComplete);
            }
        } while (message.getSubject() != Message.Subject.RQ_QUIT);
    }

    void start() {
        if (this.started) {
            throw new RuntimeException("The evaluation thread has already been started.");
        }
        this.thread = new Thread(this);
        this.thread.start();
        this.started = true;
    }
}

