% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/csvFileInput.R
\name{csvFileInput}
\alias{csvFileInput}
\title{csvFileInput: Shiny module UI for file upload.}
\usage{
csvFileInput(id, label = "Upload data (csv/xlsx/sav/sas7bdat/dta)")
}
\arguments{
\item{id}{A string, the module id.}

\item{label}{A string, the label for the file input,
Default: 'Upload data (csv/xlsx/sav/sas7bdat/dta)'}
}
\value{
A Shiny UI object.
}
\description{
Shiny module UI for file upload supporting csv, xlsx, sav,
sas7bdat, and dta formats. It provides UI outputs for various data
manipulation options.
}
\details{
This function only defines the UI. The corresponding server
function, `csvFile`, handles the logic.
}
\examples{
if (interactive()) {
  library(shiny)
  library(DT)
  library(jstable)

  ui <- fluidPage(
    sidebarLayout(
      sidebarPanel(
        csvFileInput("datafile")
      ),
      mainPanel(
        tabsetPanel(
          type = "pills",
          tabPanel("Data", DTOutput("data")),
          tabPanel("Label", DTOutput("data_label"))
        )
      )
    )
  )

  server <- function(input, output, session) {
    data_info <- callModule(csvFile, "datafile")

    output$data <- renderDT({
      data_info()$data
    })

    output$label <- renderDT({
      data_info()$label
    })
  }
  shinyApp(ui, server)
}
}
