% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/kaplan.R
\name{optionUI}
\alias{optionUI}
\title{optionUI: Option UI with icon}
\usage{
optionUI(id)
}
\arguments{
\item{id}{id}
}
\value{
Option UI with icon
}
\description{
Option UI with icon
}
\details{
Option UI with icon
}
\examples{
library(shiny)
library(DT)
library(data.table)
library(jstable)
library(ggplot2)
ui <- fluidPage(
  sidebarLayout(
    sidebarPanel(
      kaplanUI("kaplan")
    ),
    mainPanel(
      optionUI("kaplan"),
      plotOutput("kaplan_plot"),
      ggplotdownUI("kaplan")
    )
  )
)

server <- function(input, output, session) {
  data <- reactive(mtcars)
  data.label <- reactive(jstable::mk.lev(mtcars))

  out_kaplan <- callModule(kaplanModule, "kaplan",
    data = data, data_label = data.label,
    data_varStruct = NULL
  )

  output$kaplan_plot <- renderPlot({
    print(out_kaplan())
  })
}
}
\seealso{
\code{\link[shinyWidgets]{dropdownButton}},\code{\link[shinyWidgets]{tooltipOptions}}
}
