% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/roc.R
\name{rocModule}
\alias{rocModule}
\title{rocModule: shiny module server for roc analysis}
\usage{
rocModule(
  input,
  output,
  session,
  data,
  data_label,
  data_varStruct = NULL,
  nfactor.limit = 10,
  design.survey = NULL,
  id.cluster = NULL
)
}
\arguments{
\item{input}{input}

\item{output}{output}

\item{session}{session}

\item{data}{Reactive data}

\item{data_label}{Reactuve data label}

\item{data_varStruct}{Reactive List of variable structure, Default: NULL}

\item{nfactor.limit}{nlevels limit in factor variable, Default: 10}

\item{design.survey}{Reactive survey data. default: NULL}

\item{id.cluster}{Reactive cluster variable if marginal model, Default: NULL}
}
\value{
shiny module server for roc analysis
}
\description{
shiny module server for roc analysis
}
\details{
shiny module server for roc analysis
}
\examples{
library(shiny);library(DT);library(data.table);library(jstable);library(ggplot2);library(pROC)
ui <- fluidPage(
   sidebarLayout(
   sidebarPanel(
     rocUI("roc")
   ),
   mainPanel(
     plotOutput("plot_roc"),
     ggplotdownUI("roc"),
     DTOutput("table_roc")
   )
 )
)

server <- function(input, output, session) {

  data <- reactive(mtcars)
  data.label <- jstable::mk.lev(mtcars)

  out_roc <- callModule(rocModule, "roc", data = data, data_label = data.label,
                            data_varStruct = NULL)

  output$plot_roc <- renderPlot({
    print(out_roc()$plot)
  })

  output$table_roc <- renderDT({
    datatable(out_roc()$tb, rownames=F, editable = F, extensions= "Buttons",
              caption = "ROC results",
              options = c(jstable::opt.tbreg("roctable"), list(scrollX = TRUE)))
  })
}
}
\seealso{
\code{\link[stats]{quantile}}
 \code{\link[data.table]{setkey}}
 \code{\link[pROC]{ggroc}}
 \code{\link[geepack]{geeglm}}
 \code{\link[survey]{svyglm}}
 \code{\link[see]{theme_modern}}
}
