% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gee.R
\name{GEEModuleUI}
\alias{GEEModuleUI}
\title{GEEModuleUI: shiny modulde UI for generalized estimating equation(GEE).}
\usage{
GEEModuleUI(id)
}
\arguments{
\item{id}{id}
}
\value{
Shiny modulde UI for generalized estimating equation(GEE).
}
\description{
Shiny modulde UI for generalized estimating equation(GEE).
}
\details{
Shiny modulde UI for generalized estimating equation(GEE).
}
\examples{
library(shiny);library(DT);library(data.table);library(jstable)
ui <- fluidPage(
   sidebarLayout(
   sidebarPanel(
     GEEModuleUI("linear")
   ),
   mainPanel(
     DTOutput("lineartable")
   )
 )
)

server <- function(input, output, session) {

  data <- reactive(mtcars)
  data.label <- reactive(jstable::mk.lev(mtcars))
  id.gee <- reactive("mpg")

  out_linear <- callModule(GEEModuleLinear, "linear", data = data, data_label = data.label,
                           data_varStruct = NULL, id.gee = id.gee)

  output$lineartable <- renderDT({
    hide = which(colnames(out_linear()$table) == "sig")
    datatable(out_linear()$table, rownames=T, extension= "Buttons", caption = out_linear()$caption,
              options = c(opt.tbreg(out_linear()$caption),
                          list(columnDefs = list(list(visible=FALSE, targets =hide))
                          ),
                          list(scrollX = TRUE)
              )
    ) \%>\% formatStyle("sig", target = 'row',backgroundColor = styleEqual("**", 'yellow'))
  })
}
}
