% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tb1.R
\name{tb1module}
\alias{tb1module}
\title{tb1module: table 1 shiny module server.}
\usage{
tb1module(input, output, session, data, data_label,
  data_varStruct = NULL, nfactor.limit = 10, design.survey = NULL)
}
\arguments{
\item{input}{input}

\item{output}{output}

\item{session}{session}

\item{data}{Data}

\item{data_label}{Data label}

\item{data_varStruct}{Variable structure list of data, Default: NULL}

\item{nfactor.limit}{maximum factor levels to include, Default: 10}

\item{design.survey}{survey data of survey package. default: NULL}
}
\value{
Table 1 shiny module server for descriptive statistics.
}
\description{
Table 1 shiny module server for descriptive statistics.
}
\details{
Table 1 shiny module server for descriptive statistics.
}
\examples{
library(shiny);library(DT);library(data.table);library(jstable)
ui <- fluidPage(
   sidebarLayout(
   sidebarPanel(
     tb1moduleUI("tb1")
   ),
   mainPanel(
     DTOutput("table1")
   )
 )
)

server <- function(input, output, session) {

  data <- mtcars
  data.label <- jstable::mk.lev(mtcars)

  out_tb1 <- callModule(tb1module, "tb1", data = data, data_label = data.label,
                        data_varStruct = NULL)

  output$table1 <- renderDT({
  tb <- out_tb1()$table
  cap <- out_tb1()$caption
  out.tb1 <- datatable(tb, rownames = T, extension= "Buttons", caption = cap)
  return(out.tb1)
  })
}
}
