% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/dcf.R
\name{irr}
\alias{irr}
\title{Internal Rate of Return}
\usage{
irr(cf, interval = NULL, cf.freq = 1, comp.freq = 1, cf.t = seq(from =
  0, by = 1/cf.freq, along.with = cf), r.guess = NULL, toler = 1e-06,
  convergence = 1e-08, max.iter = 100, method = c("default", "newton",
  "bisection"))
}
\arguments{
\item{cf}{Vector of cash flows}

\item{interval}{the interval c(lower, upper) within which to
search for the IRR}

\item{cf.freq}{Frequency of annuity payments: 1 for annual, 2 for
semi-annual, 12 for monthly.}

\item{comp.freq}{Frequency of compounding of interest rates: 1 for annual,
2 for semi-annual, 12 for monthly, Inf for continuous compounding.}

\item{cf.t}{Optional vector of timing (in years) of cash flows. If omitted
regular sequence of years is assumed.}

\item{r.guess}{the starting value (guess) from which the solver
starts searching for the IRR}

\item{toler}{the argument \code{toler} for
\code{\link{irr.solve}}.  The IRR is regarded as correct if
abs(NPV) is less than toler.  Otherwise the \code{irr}
function returns \code{NA}}

\item{convergence}{the argument \code{convergence} for
\code{\link{irr.solve}}}

\item{max.iter}{the argument \code{max.iter} for
\code{\link{irr.solve}}}

\item{method}{The root finding method to be used. The
\code{default} is to try Newton-Raphson method
(\code{\link{newton.raphson.root}}) and if that fails to try
bisection (\code{\link{bisection.root}}). The other two
choices (\code{newton} and \code{bisection} force only one of
the methods to be tried.}
}
\description{
Computes IRR (Internal Rate of Return) for cash flows with different cash flow and
compounding conventions. Cash flows need not be evenly spaced.
}

