% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/jrSiCKLSNMF.R
\name{NormalizeCountMatrices}
\alias{NormalizeCountMatrices}
\title{Normalize the count matrices and set whether to use the Poisson KL divergence
or the Frobenius norm}
\usage{
NormalizeCountMatrices(SickleJr, diffFunc = "klp", scaleFactor = NULL)
}
\arguments{
\item{SickleJr}{An object of class SickleJr}

\item{diffFunc}{A string set to "klp" when using the Poisson KL divergence
or to "fr" when using the Frobenius norm: default is KL divergence; this also determines
the type of normalization}

\item{scaleFactor}{A single numeric value (if using the same scale factor for each modality)
or a list of numeric values to use (if using different scale factors in different modalities)
as scale factors for the log\eqn{(x+1)} normalization when \code{diffFunc="fr"}}
}
\value{
An object of class SickleJr with a list of sparse, normalized data matrices added to its \code{normalized.count.matrices} slot
}
\description{
Normalize the count data within each modality. The default
normalization, which should be used when using the KL divergence, is median
library size normalization \insertCite{Zheng2017,Elyanow2020}{jrSiCKLSNMF}. To perform median library size normalization,
each count within a cell is divided by its library size (i.e. the counts within a column are divided by the
column sum). Then, all values are multiplied by the median library size
(i.e. the median column sum). To use the Frobenius norm, set \code{frob=TRUE} to log\eqn{(x+1)}
normalize your count data and use a desired \code{scaleFactor}.
You may also use a different form of normalization and store these results
in the \code{normalized.count.matrices} slot.
}
\examples{
SimSickleJrSmall<-NormalizeCountMatrices(SimSickleJrSmall)
SimSickleJrSmall<-NormalizeCountMatrices(SimSickleJrSmall, diffFunc="fr",scaleFactor=1e6)
}
\references{
\insertRef{Elyanow2020}{jrSiCKLSNMF}

\insertRef{Zheng2017}{jrSiCKLSNMF}
}
