% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/index.R
\name{index}
\alias{dotindex}
\alias{dotindex_}
\alias{index}
\alias{index_}
\alias{indexif}
\alias{indexif_}
\title{index and related functions}
\usage{
index(.data, ...)

index_(.data, ..., .dots)

indexif(.data, ...)

indexif_(.data, ..., .dots)

dotindex(.data, ...)

dotindex_(.data, ..., .dots)
}
\arguments{
\item{.data}{input. This can be JSON input, or an object of class
\code{jqr} that has JSON and query params combined, which is passed
from function to function when using the jqr DSL.}

\item{...}{Comma separated list of unquoted variable names}

\item{.dots}{Used to work around non-standard evaluation}

\item{dots}{dots}
}
\description{
index and related functions
}
\details{
\itemize{
 \item \code{index}/\code{index_} - queries like: \code{.[]}, \code{.[0]}, \code{.[1:5]},
 \code{.["foo"]}
 \item \code{indexif}/\code{indexif_} - queries like: \code{.[foo?]}
 \item \code{dotindex}/\code{dotindex_} - queries like: \code{.[].foo}, \code{.[].foo.bar}
}
}
\examples{
str <- '[{"name":"JSON", "good":true}, {"name":"XML", "good":false}]'
str \%>\% index
str \%>\% indexif
str \%>\% indexif(name)
'{"name":"JSON", "good":true}' \%>\% indexif(name)
'{"name":"JSON", "good":true}' \%>\% indexif(good)
'{"name":"JSON", "good":true}' \%>\% indexif(that)
'{"a": 1, "b": 1}' \%>\% index
'[]' \%>\% index
'[{"name":"JSON", "good":true}, {"name":"XML", "good":false}]' \%>\% index(0)
'["a","b","c","d","e"]' \%>\% index(2)
'["a","b","c","d","e"]' \%>\% index('2:4')
'["a","b","c","d","e"]' \%>\% index('2:5')
'["a","b","c","d","e"]' \%>\% index(':3')
'["a","b","c","d","e"]' \%>\% index('-2:')

str \%>\% index \%>\% select(bad = .name)

'[{"name":"JSON", "good":true}, {"name":"XML", "good":false}]' \%>\% dotindex(name)
'[{"name":"JSON", "good":true}, {"name":"XML", "good":false}]' \%>\% dotindex(good)
'[{"name":"JSON", "good":{"foo":5}}, {"name":"XML", "good":{"foo":6}}]' \%>\% dotindex(good)
'[{"name":"JSON", "good":{"foo":5}}, {"name":"XML", "good":{"foo":6}}]' \%>\% dotindex(good.foo)
}

